import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render the final JSX of Textarea
 */
export declare const renderTextarea_unstable: (state: TextareaState) => JSXElement;

/**
 * The Textarea component allows the user to enter and edit text in multiple lines.
 */
export declare const Textarea: ForwardRefComponent<TextareaProps>;

export declare const textareaClassNames: SlotClassNames<TextareaSlots>;

/**
 * Data passed to the `onChange` callback when the textarea's value changes.
 */
export declare type TextareaOnChangeData = {
    value: string;
};

/**
 * Textarea Props
 */
export declare type TextareaProps = Omit<ComponentProps<Partial<TextareaSlots>, 'textarea'>, 'defaultValue' | 'onChange' | 'size' | 'value'> & {
    /**
     * Styling the Textarea should use.
     *
     * @default outline
     *
     * Note: 'filled-darker-shadow' and 'filled-lighter-shadow' are deprecated and will be removed in the future.
     */
    appearance?: 'outline' | 'filled-darker' | 'filled-lighter' | 'filled-darker-shadow' | 'filled-lighter-shadow';
    /**
     * The default value of the Textarea.
     */
    defaultValue?: string;
    /**
     * Callback for when the user changes the value.
     */
    onChange?: (ev: React_2.ChangeEvent<HTMLTextAreaElement>, data: TextareaOnChangeData) => void;
    /**
     * Which direction the Textarea is allowed to be resized.
     *
     * @default none
     */
    resize?: 'none' | 'horizontal' | 'vertical' | 'both';
    /**
     * Size of the Textarea.
     *
     * @default medium
     */
    size?: 'small' | 'medium' | 'large';
    /**
     * The value of the Textarea.
     */
    value?: string;
};

export declare type TextareaSlots = {
    /**
     * Wrapper element used for displaying the borders for Textarea. This wrapper is needed due to the focus
     * indicator border animation. For more information, see Spec.md
     *
     * The root only receives `className` and `style`. All other props are applied to the `textarea` slot.
     */
    root: NonNullable<Slot<'span'>>;
    /**
     * The `<textarea>` element. This is the primary slot, all native props and ref are applied to this slot.
     */
    textarea: NonNullable<Slot<'textarea'>>;
};

/**
 * State used in rendering Textarea
 */
export declare type TextareaState = ComponentState<TextareaSlots> & Required<Pick<TextareaProps, 'appearance' | 'resize' | 'size'>>;

/**
 * Create the state required to render Textarea.
 *
 * The returned state can be modified with hooks such as useTextareaStyles_unstable,
 * before being passed to renderTextarea_unstable.
 *
 * @param props - props from this instance of Textarea
 * @param ref - reference to root HTMLElement of Textarea
 */
export declare const useTextarea_unstable: (props: TextareaProps, ref: React_2.Ref<HTMLTextAreaElement>) => TextareaState;

/**
 * Apply styling to the Textarea slots based on the state
 */
export declare const useTextareaStyles_unstable: (state: TextareaState) => TextareaState;

export { }
