'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    textClassNames: function() {
        return textClassNames;
    },
    useTextStyles_unstable: function() {
        return useTextStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const textClassNames = {
    root: 'fui-Text'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        fontSize: _reacttheme.tokens.fontSizeBase300,
        lineHeight: _reacttheme.tokens.lineHeightBase300,
        fontWeight: _reacttheme.tokens.fontWeightRegular,
        textAlign: 'start',
        display: 'inline',
        whiteSpace: 'normal',
        overflow: 'visible',
        textOverflow: 'clip'
    },
    nowrap: {
        whiteSpace: 'nowrap',
        overflow: 'hidden'
    },
    truncate: {
        textOverflow: 'ellipsis'
    },
    block: {
        display: 'block'
    },
    italic: {
        fontStyle: 'italic'
    },
    underline: {
        textDecorationLine: 'underline'
    },
    strikethrough: {
        textDecorationLine: 'line-through'
    },
    strikethroughUnderline: {
        textDecorationLine: 'line-through underline'
    },
    base100: {
        fontSize: _reacttheme.tokens.fontSizeBase100,
        lineHeight: _reacttheme.tokens.lineHeightBase100
    },
    base200: {
        fontSize: _reacttheme.tokens.fontSizeBase200,
        lineHeight: _reacttheme.tokens.lineHeightBase200
    },
    base400: {
        fontSize: _reacttheme.tokens.fontSizeBase400,
        lineHeight: _reacttheme.tokens.lineHeightBase400
    },
    base500: {
        fontSize: _reacttheme.tokens.fontSizeBase500,
        lineHeight: _reacttheme.tokens.lineHeightBase500
    },
    base600: {
        fontSize: _reacttheme.tokens.fontSizeBase600,
        lineHeight: _reacttheme.tokens.lineHeightBase600
    },
    hero700: {
        fontSize: _reacttheme.tokens.fontSizeHero700,
        lineHeight: _reacttheme.tokens.lineHeightHero700
    },
    hero800: {
        fontSize: _reacttheme.tokens.fontSizeHero800,
        lineHeight: _reacttheme.tokens.lineHeightHero800
    },
    hero900: {
        fontSize: _reacttheme.tokens.fontSizeHero900,
        lineHeight: _reacttheme.tokens.lineHeightHero900
    },
    hero1000: {
        fontSize: _reacttheme.tokens.fontSizeHero1000,
        lineHeight: _reacttheme.tokens.lineHeightHero1000
    },
    monospace: {
        fontFamily: _reacttheme.tokens.fontFamilyMonospace
    },
    numeric: {
        fontFamily: _reacttheme.tokens.fontFamilyNumeric
    },
    weightMedium: {
        fontWeight: _reacttheme.tokens.fontWeightMedium
    },
    weightSemibold: {
        fontWeight: _reacttheme.tokens.fontWeightSemibold
    },
    weightBold: {
        fontWeight: _reacttheme.tokens.fontWeightBold
    },
    alignCenter: {
        textAlign: 'center'
    },
    alignEnd: {
        textAlign: 'end'
    },
    alignJustify: {
        textAlign: 'justify'
    }
});
const useTextStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(textClassNames.root, styles.root, state.wrap === false && styles.nowrap, state.truncate && styles.truncate, state.block && styles.block, state.italic && styles.italic, state.underline && styles.underline, state.strikethrough && styles.strikethrough, state.underline && state.strikethrough && styles.strikethroughUnderline, state.size === 100 && styles.base100, state.size === 200 && styles.base200, state.size === 400 && styles.base400, state.size === 500 && styles.base500, state.size === 600 && styles.base600, state.size === 700 && styles.hero700, state.size === 800 && styles.hero800, state.size === 900 && styles.hero900, state.size === 1000 && styles.hero1000, state.font === 'monospace' && styles.monospace, state.font === 'numeric' && styles.numeric, state.weight === 'medium' && styles.weightMedium, state.weight === 'semibold' && styles.weightSemibold, state.weight === 'bold' && styles.weightBold, state.align === 'center' && styles.alignCenter, state.align === 'end' && styles.alignEnd, state.align === 'justify' && styles.alignJustify, state.root.className);
    return state;
};
