import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Text preset component for the Body1 typography variant
 */
export declare const Body1: React_2.FunctionComponent<TextPresetProps>;

export declare const body1ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Body1Strong typography variant
 */
export declare const Body1Strong: React_2.FunctionComponent<TextPresetProps>;

export declare const body1StrongClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Body1Stronger typography variant
 */
export declare const Body1Stronger: React_2.FunctionComponent<TextPresetProps>;

export declare const body1StrongerClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Body2 typography variant
 */
export declare const Body2: React_2.FunctionComponent<TextPresetProps>;

export declare const body2ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Caption1 typography variant
 */
export declare const Caption1: React_2.FunctionComponent<TextPresetProps>;

export declare const caption1ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Caption1Strong typography variant
 */
export declare const Caption1Strong: React_2.FunctionComponent<TextPresetProps>;

export declare const caption1StrongClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Caption1Stronger typography variant
 */
export declare const Caption1Stronger: React_2.FunctionComponent<TextPresetProps>;

export declare const caption1StrongerClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Caption2 typography variant
 */
export declare const Caption2: React_2.FunctionComponent<TextPresetProps>;

export declare const caption2ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Caption2Strong typography variant
 */
export declare const Caption2Strong: React_2.FunctionComponent<TextPresetProps>;

export declare const caption2StrongClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Display typography variant
 */
export declare const Display: React_2.FunctionComponent<TextPresetProps>;

export declare const displayClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Large Title typography variant
 */
export declare const LargeTitle: React_2.FunctionComponent<TextPresetProps>;

export declare const largeTitleClassNames: SlotClassNames<TextSlots>;

/**
 * Render the final JSX of Text
 */
export declare const renderText_unstable: (state: TextState) => JSXElement;

/**
 * Text preset component for the Subtitle1 typography variant
 */
export declare const Subtitle1: React_2.FunctionComponent<TextPresetProps>;

export declare const subtitle1ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Subtitle2 typography variant
 */
export declare const Subtitle2: React_2.FunctionComponent<TextPresetProps>;

export declare const subtitle2ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Subtitle2Stronger typography variant
 */
export declare const Subtitle2Stronger: React_2.FunctionComponent<TextPresetProps>;

export declare const subtitle2StrongerClassNames: SlotClassNames<TextSlots>;

/**
 * Typography and styling abstraction component used to ensure consistency of text.
 */
declare const Text_2: ForwardRefComponent<TextProps>;
export { Text_2 as Text }

export declare const textClassNames: SlotClassNames<TextSlots>;

/**
 * TextPreset Props
 */
export declare type TextPresetProps = Omit<TextProps, 'font' | 'size' | 'weight'>;

/**
 * Text Props
 */
export declare type TextProps = ComponentProps<TextSlots> & {
    /**
     * Aligns text based on the parent container.
     *
     * @default start
     */
    align?: 'start' | 'center' | 'end' | 'justify';
    /**
     * Applies a block display for the content.
     *
     * @default false
     */
    block?: boolean;
    /**
     * Applies the font family to the content.
     *
     * @default base
     */
    font?: 'base' | 'monospace' | 'numeric';
    /**
     * Applies the italic font style to the content.
     *
     * @default false
     */
    italic?: boolean;
    /**
     * Applies font size and line height based on the theme typography tokens.
     *
     * @default 300
     */
    size?: 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 | 1000;
    /**
     * Applies the strikethrough text decoration to the content.
     *
     * @default false
     */
    strikethrough?: boolean;
    /**
     * Truncate overflowing text for block displays.
     *
     * @default false
     */
    truncate?: boolean;
    /**
     * Applies the underline text decoration to the content.
     *
     * @default false
     */
    underline?: boolean;
    /**
     * Applies font weight to the content.
     *
     * @default regular
     */
    weight?: 'regular' | 'medium' | 'semibold' | 'bold';
    /**
     * Wraps the text content on white spaces.
     *
     * @default true
     */
    wrap?: boolean;
};

/**
 * Text slots
 */
export declare type TextSlots = {
    root: Slot<'span', 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6' | 'p' | 'pre' | 'strong' | 'b' | 'em' | 'i'>;
};

/**
 * State used in rendering Text
 */
export declare type TextState = ComponentState<TextSlots> & Required<Pick<TextProps, 'align' | 'block' | 'font' | 'italic' | 'size' | 'strikethrough' | 'truncate' | 'underline' | 'weight' | 'wrap'>>;

/**
 * Text preset component for the Title 1 typography variant
 */
export declare const Title1: React_2.FunctionComponent<TextPresetProps>;

export declare const title1ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Title 2 typography variant
 */
export declare const Title2: React_2.FunctionComponent<TextPresetProps>;

export declare const title2ClassNames: SlotClassNames<TextSlots>;

/**
 * Text preset component for the Title 3 typography variant
 */
export declare const Title3: React_2.FunctionComponent<TextPresetProps>;

export declare const title3ClassNames: SlotClassNames<TextSlots>;

/**
 * Create the state required to render Text.
 *
 * The returned state can be modified with hooks such as useTextStyles_unstable,
 * before being passed to renderText_unstable.
 *
 * @param props - props from this instance of Text
 * @param ref - reference to root HTMLElement of Text
 */
export declare const useText_unstable: (props: TextProps, ref: React_2.Ref<HTMLElement>) => TextState;

/**
 * Apply styling to the Text slots based on the state
 */
export declare const useTextStyles_unstable: (state: TextState) => TextState;

export { }
