'use client';
import { makeStyles, mergeClasses } from '@griffel/react';
import { usePopoverSurfaceStyles_unstable } from '@fluentui/react-popover';
import { tokens } from '@fluentui/react-theme';
export const teachingPopoverSurfaceClassNames = {
    root: 'fui-TeachingPopoverSurface'
};
const useStyles = makeStyles({
    root: {
        padding: `${tokens.spacingVerticalL} ${tokens.spacingVerticalL}`,
        borderRadius: tokens.borderRadiusXLarge,
        minWidth: '320px',
        boxSizing: 'border-box'
    }
});
/**
 * Apply styling to the TeachingPopoverSurface slots based on the state
 */ export const useTeachingPopoverSurfaceStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    // Make sure to merge teaching bubble surface prior to popover styles
    state.root.className = mergeClasses(teachingPopoverSurfaceClassNames.root, styles.root, state.root.className);
    const updatedState = usePopoverSurfaceStyles_unstable(state);
    return updatedState;
};
