'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot } from '@fluentui/react-utilities';
import { useCarouselValues_unstable } from '../TeachingPopoverCarousel/Carousel/useCarouselValues';
import { useCarouselContext_unstable } from '../TeachingPopoverCarousel/Carousel/CarouselContext';
/**
 * Create the state required to render TeachingPopoverCarouselPageCount.
 *
 * The returned state can be modified with hooks such as useTeachingPopoverCarouselPageCountStyles_unstable,
 * before being passed to renderTeachingPopoverCarouselPageCount_unstable.
 *
 * @param props - props from this instance of TeachingPopoverCarouselPageCount
 * @param ref - reference to root HTMLDivElement of TeachingPopoverCarouselPageCount
 */ export const useTeachingPopoverCarouselPageCount_unstable = (props, ref)=>{
    const values = useCarouselValues_unstable((snapshot)=>snapshot);
    var _useCarouselContext_unstable;
    const selectedValue = (_useCarouselContext_unstable = useCarouselContext_unstable((c)=>c.value)) !== null && _useCarouselContext_unstable !== void 0 ? _useCarouselContext_unstable : values[0];
    const currentIndex = values.indexOf(selectedValue);
    const totalPages = values.length;
    return {
        currentIndex,
        totalPages,
        renderPageCount: props.children,
        components: {
            root: 'div'
        },
        root: slot.always(getIntrinsicElementProps('div', {
            ref,
            ...props,
            children: props.children(currentIndex + 1, totalPages)
        }), {
            elementType: 'div'
        })
    };
};
