'use client';
import { makeStyles, mergeClasses, shorthands } from '@griffel/react';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
import { tokens } from '@fluentui/react-theme';
export const teachingPopoverCarouselNavClassNames = {
    root: 'fui-TeachingPopoverCarouselNav'
};
const useStyles = makeStyles({
    root: {
        display: 'flex',
        flexDirection: 'row',
        columnGap: tokens.spacingHorizontalXS,
        alignItems: 'center',
        justifyContent: 'center',
        ...createCustomFocusIndicatorStyle({
            outline: `${tokens.strokeWidthThick} solid ${tokens.colorStrokeFocus2}`,
            borderRadius: tokens.borderRadiusMedium,
            ...shorthands.borderColor('transparent')
        })
    }
});
/** Applies style classnames to slots */ export const useTeachingPopoverCarouselNavStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = mergeClasses(teachingPopoverCarouselNavClassNames.root, styles.root, state.root.className);
    return state;
};
