'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot, useEventCallback, useMergedRefs } from '@fluentui/react-utilities';
import { usePopoverContext_unstable } from '@fluentui/react-popover';
import { useCarousel_unstable } from './Carousel/Carousel';
export const useTeachingPopoverCarousel_unstable = (props, ref)=>{
    const toggleOpen = usePopoverContext_unstable((c)=>c.toggleOpen);
    const handleFinish = useEventCallback((event, data)=>{
        var _props_onFinish;
        (_props_onFinish = props.onFinish) === null || _props_onFinish === void 0 ? void 0 : _props_onFinish.call(props, event, data);
        toggleOpen(event);
    });
    const { carousel, carouselRef } = useCarousel_unstable({
        announcement: props.announcement,
        defaultValue: props.defaultValue,
        value: props.value,
        onValueChange: props.onValueChange,
        onFinish: handleFinish
    });
    const appearance = usePopoverContext_unstable((context)=>context.appearance);
    return {
        appearance,
        components: {
            root: 'div'
        },
        root: slot.always(getIntrinsicElementProps('div', {
            ref: useMergedRefs(ref, carouselRef),
            ...props
        }), {
            elementType: 'div'
        }),
        ...carousel
    };
};
