'use client';
import * as React from 'react';
import { isHTMLElement } from '@fluentui/react-utilities';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
import { CAROUSEL_ACTIVE_ITEM, CAROUSEL_ITEM } from './constants';
export const useCarouselWalker_unstable = ()=>{
    const { targetDocument } = useFluent();
    const treeWalkerRef = React.useRef(targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.createTreeWalker(targetDocument.body));
    const htmlRef = React.useRef(null);
    const ref = React.useCallback((el)=>{
        if (!targetDocument) {
            return;
        }
        if (!el) {
            return;
        }
        htmlRef.current = el;
        treeWalkerRef.current = targetDocument.createTreeWalker(el, NodeFilter.SHOW_ELEMENT, {
            acceptNode (node) {
                if (!isHTMLElement(node)) {
                    return NodeFilter.FILTER_SKIP;
                }
                return node.hasAttribute(CAROUSEL_ITEM) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
            }
        });
    }, [
        targetDocument
    ]);
    return {
        ref,
        walker: React.useMemo(()=>({
                active () {
                    if (!htmlRef.current) {
                        return null;
                    }
                    const activeEl = htmlRef.current.querySelector(`[${CAROUSEL_ACTIVE_ITEM}="true"]`);
                    if (isHTMLElement(activeEl)) {
                        return {
                            el: activeEl,
                            value: activeEl.getAttribute(CAROUSEL_ITEM)
                        };
                    }
                    return null;
                },
                find (value) {
                    var _treeWalkerRef_current;
                    if (!((_treeWalkerRef_current = treeWalkerRef.current) === null || _treeWalkerRef_current === void 0 ? void 0 : _treeWalkerRef_current.currentNode) || !htmlRef.current) {
                        return null;
                    }
                    treeWalkerRef.current.currentNode = htmlRef.current;
                    let nextNode = null;
                    while(nextNode = treeWalkerRef.current.nextNode()){
                        if (!isHTMLElement(nextNode)) {
                            continue;
                        }
                        if (nextNode.getAttribute(CAROUSEL_ITEM) === value) {
                            return {
                                el: nextNode,
                                value: nextNode.getAttribute(CAROUSEL_ITEM)
                            };
                        }
                    }
                    return null;
                },
                nextPage (value) {
                    var _treeWalkerRef_current;
                    const res = this.find(value);
                    if (!res || !((_treeWalkerRef_current = treeWalkerRef.current) === null || _treeWalkerRef_current === void 0 ? void 0 : _treeWalkerRef_current.currentNode)) {
                        return null;
                    }
                    treeWalkerRef.current.currentNode = res.el;
                    const next = treeWalkerRef.current.nextNode();
                    if (isHTMLElement(next)) {
                        return {
                            el: next,
                            value: next.getAttribute(CAROUSEL_ITEM)
                        };
                    }
                    return null;
                },
                prevPage (value) {
                    var _treeWalkerRef_current;
                    const res = this.find(value);
                    if (!res || !((_treeWalkerRef_current = treeWalkerRef.current) === null || _treeWalkerRef_current === void 0 ? void 0 : _treeWalkerRef_current.currentNode)) {
                        return null;
                    }
                    treeWalkerRef.current.currentNode = res.el;
                    const next = treeWalkerRef.current.previousNode();
                    if (isHTMLElement(next)) {
                        return {
                            el: next,
                            value: next.getAttribute(CAROUSEL_ITEM)
                        };
                    }
                    return null;
                }
            }), [])
    };
};
