'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    teachingPopoverTitleClassNames: function() {
        return teachingPopoverTitleClassNames;
    },
    useTeachingPopoverTitleStyles_unstable: function() {
        return useTeachingPopoverTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const teachingPopoverTitleClassNames = {
    root: 'fui-TeachingPopoverTitle',
    dismissButton: 'fui-TeachingPopoverTitle__dismissButton'
};
const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        fontSize: _reacttheme.tokens.fontSizeBase400,
        fontWeight: _reacttheme.tokens.fontWeightSemibold,
        color: _reacttheme.tokens.colorNeutralForeground1,
        lineHeight: _reacttheme.tokens.lineHeightBase400,
        paddingBottom: _reacttheme.tokens.spacingVerticalS,
        marginTop: _reacttheme.tokens.spacingHorizontalNone,
        marginBottom: _reacttheme.tokens.spacingHorizontalNone
    },
    rootBrand: {
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    dismissButton: {
        position: 'relative',
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
        display: 'flex',
        alignItems: 'center',
        cursor: 'pointer',
        ..._reacttheme.typographyStyles.body1,
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        boxSizing: 'border-box',
        borderTopRightRadius: _reacttheme.tokens.borderRadiusNone,
        borderBottomRightRadius: _reacttheme.tokens.borderRadiusNone,
        borderRightStyle: 'none',
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            ..._react.shorthands.borderColor('transparent')
        }),
        marginInlineStart: 'auto'
    },
    dismissBrand: {
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    }
});
const useTeachingPopoverTitleStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { appearance } = state;
    state.root.className = (0, _react.mergeClasses)(teachingPopoverTitleClassNames.root, styles.root, appearance === 'brand' && styles.rootBrand, state.root.className);
    if (state.dismissButton) {
        state.dismissButton.className = (0, _react.mergeClasses)(teachingPopoverTitleClassNames.dismissButton, styles.dismissButton, appearance === 'brand' ? styles.dismissBrand : undefined, state.dismissButton.className);
    }
    return state;
};
