'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    teachingPopoverHeaderClassNames: function() {
        return teachingPopoverHeaderClassNames;
    },
    useTeachingPopoverHeaderStyles_unstable: function() {
        return useTeachingPopoverHeaderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const teachingPopoverHeaderClassNames = {
    root: 'fui-TeachingPopoverHeader',
    dismissButton: 'fui-TeachingPopoverHeader__dismissButton',
    icon: 'fui-TeachingPopoverHeader__icon'
};
const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'row',
        color: _reacttheme.tokens.colorNeutralForeground3,
        fontWeight: _reacttheme.tokens.fontWeightSemibold,
        fontSize: _reacttheme.tokens.fontSizeBase200,
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        paddingBottom: _reacttheme.tokens.spacingVerticalXS,
        alignItems: 'center',
        marginTop: _reacttheme.tokens.spacingHorizontalNone,
        marginBottom: _reacttheme.tokens.spacingHorizontalNone
    },
    rootBrand: {
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    dismissButton: {
        color: _reacttheme.tokens.colorNeutralForeground2,
        position: 'relative',
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
        display: 'flex',
        alignItems: 'center',
        cursor: 'pointer',
        ..._reacttheme.typographyStyles.body1,
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        boxSizing: 'border-box',
        borderTopRightRadius: _reacttheme.tokens.borderRadiusNone,
        borderBottomRightRadius: _reacttheme.tokens.borderRadiusNone,
        borderRightStyle: 'none',
        marginInlineStart: 'auto',
        padding: `${_reacttheme.tokens.spacingVerticalXS} ${_reacttheme.tokens.spacingHorizontalXS}`,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            ..._react.shorthands.borderColor('transparent')
        })
    },
    dismissBrand: {
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    icon: {
        height: _reacttheme.tokens.fontSizeBase200,
        width: _reacttheme.tokens.fontSizeBase200,
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        fontSize: _reacttheme.tokens.fontSizeBase200,
        alignItems: 'center',
        boxSizing: 'content-box',
        display: 'inline-flex',
        justifyContent: 'center',
        textDecorationLine: 'none',
        verticalAlign: 'middle',
        position: 'relative',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        color: _reacttheme.tokens.colorNeutralForeground2,
        marginInlineEnd: _reacttheme.tokens.spacingHorizontalXS
    },
    iconBrand: {
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    }
});
const useTeachingPopoverHeaderStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { appearance } = state;
    state.root.className = (0, _react.mergeClasses)(teachingPopoverHeaderClassNames.root, styles.root, appearance === 'brand' && styles.rootBrand, state.root.className);
    if (state.dismissButton) {
        state.dismissButton.className = (0, _react.mergeClasses)(teachingPopoverHeaderClassNames.dismissButton, styles.dismissButton, appearance === 'brand' ? styles.dismissBrand : undefined, state.dismissButton.className);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(teachingPopoverHeaderClassNames.icon, styles.icon, appearance === 'brand' ? styles.iconBrand : undefined, state.icon.className);
    }
    return state;
};
