'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTeachingPopoverHeader_unstable", {
    enumerable: true,
    get: function() {
        return useTeachingPopoverHeader_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacticons = require("@fluentui/react-icons");
const _reactpopover = require("@fluentui/react-popover");
const useTeachingPopoverHeader_unstable = (props, ref)=>{
    const { dismissButton, icon } = props;
    const setOpen = (0, _reactpopover.usePopoverContext_unstable)((context)=>context.setOpen);
    const triggerRef = (0, _reactpopover.usePopoverContext_unstable)((context)=>context.triggerRef);
    const appearance = (0, _reactpopover.usePopoverContext_unstable)((context)=>context.appearance);
    const onDismissButtonClick = (0, _reactutilities.useEventCallback)((ev)=>{
        if (!ev.defaultPrevented) {
            setOpen(ev, false);
        }
        if (triggerRef.current) {
            triggerRef.current.focus();
        }
    });
    return {
        appearance,
        components: {
            root: 'div',
            dismissButton: 'button',
            icon: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            ...props
        }), {
            elementType: 'div'
        }),
        icon: _reactutilities.slot.optional(icon, {
            renderByDefault: true,
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_reacticons.Lightbulb16Regular, null),
                'aria-hidden': true
            },
            elementType: 'div'
        }),
        dismissButton: _reactutilities.slot.optional(dismissButton, {
            renderByDefault: true,
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_reacticons.Dismiss12Regular, null),
                role: 'button',
                'aria-label': 'dismiss',
                onClick: onDismissButtonClick
            },
            elementType: 'button'
        })
    };
};
