'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    teachingPopoverFooterClassNames: function() {
        return teachingPopoverFooterClassNames;
    },
    useTeachingPopoverFooterStyles_unstable: function() {
        return useTeachingPopoverFooterStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const teachingPopoverFooterClassNames = {
    root: 'fui-TeachingPopoverFooter',
    primary: 'fui-TeachingPopoverFooter__primary',
    secondary: 'fui-TeachingPopoverFooter__secondary'
};
const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        gap: '8px',
        paddingTop: '12px'
    },
    rootVertical: {
        flexDirection: 'column'
    },
    rootHorizontal: {
        flexDirection: 'row',
        justifyContent: 'flex-end'
    },
    buttonRootVertical: {
        width: 'auto',
        borderRadius: '4px'
    },
    buttonRootHorizontal: {
        minWidth: '96px',
        borderRadius: '4px'
    },
    brandSecondary: {
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralForegroundOnBrand)
    },
    brandPrimary: {
        color: _reacttheme.tokens.colorBrandForeground1,
        backgroundColor: _reacttheme.tokens.colorNeutralForegroundOnBrand,
        ':hover': {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover,
            backgroundColor: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        ':hover:active': {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed,
            backgroundColor: _reacttheme.tokens.colorNeutralForegroundOnBrand
        }
    }
});
const useTeachingPopoverFooterStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { appearance, footerLayout } = state;
    state.root.className = (0, _react.mergeClasses)(teachingPopoverFooterClassNames.root, styles.root, footerLayout === 'horizontal' ? styles.rootHorizontal : styles.rootVertical, state.root.className);
    if (state.secondary) {
        state.secondary.className = (0, _react.mergeClasses)(teachingPopoverFooterClassNames.secondary, footerLayout === 'horizontal' ? styles.buttonRootHorizontal : styles.buttonRootVertical, appearance === 'brand' ? styles.brandSecondary : undefined, state.secondary.className);
    }
    state.primary.className = (0, _react.mergeClasses)(teachingPopoverFooterClassNames.primary, footerLayout === 'horizontal' ? styles.buttonRootHorizontal : styles.buttonRootVertical, appearance === 'brand' ? styles.brandPrimary : undefined, state.primary.className);
    return state;
};
