'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTeachingPopoverFooter_unstable", {
    enumerable: true,
    get: function() {
        return useTeachingPopoverFooter_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactbutton = require("@fluentui/react-button");
const _reactpopover = require("@fluentui/react-popover");
const useTeachingPopoverFooter_unstable = (props, ref)=>{
    const appearance = (0, _reactpopover.usePopoverContext_unstable)((context)=>context.appearance);
    const toggleOpen = (0, _reactpopover.usePopoverContext_unstable)((context)=>context.toggleOpen);
    const handleButtonClick = (0, _reactutilities.useEventCallback)((event)=>{
        if (event.isDefaultPrevented()) {
            return;
        }
        toggleOpen(event);
    });
    const secondary = _reactutilities.slot.optional(props.secondary, {
        defaultProps: {
            appearance: appearance === 'brand' ? 'primary' : undefined
        },
        renderByDefault: props.secondary !== undefined,
        elementType: _reactbutton.Button
    });
    // Merge any provided callback with close trigger
    if (secondary) {
        secondary.onClick = (0, _reactutilities.mergeCallbacks)(handleButtonClick, secondary === null || secondary === void 0 ? void 0 : secondary.onClick);
    }
    const primary = _reactutilities.slot.always(props.primary, {
        defaultProps: {
            appearance: appearance === 'brand' ? undefined : 'primary'
        },
        elementType: _reactbutton.Button
    });
    // Primary button will close the popover if no secondary action is available.
    if (!secondary) {
        primary.onClick = (0, _reactutilities.mergeCallbacks)(handleButtonClick, primary === null || primary === void 0 ? void 0 : primary.onClick);
    }
    var _props_footerLayout;
    return {
        footerLayout: (_props_footerLayout = props.footerLayout) !== null && _props_footerLayout !== void 0 ? _props_footerLayout : 'horizontal',
        appearance,
        components: {
            root: 'div',
            primary: _reactbutton.Button,
            secondary: _reactbutton.Button
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            ...props
        }), {
            elementType: 'div'
        }),
        secondary,
        primary
    };
};
