'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    teachingPopoverCarouselNavButtonClassNames: function() {
        return teachingPopoverCarouselNavButtonClassNames;
    },
    useTeachingPopoverCarouselNavButtonStyles_unstable: function() {
        return useTeachingPopoverCarouselNavButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const teachingPopoverCarouselNavButtonClassNames = {
    root: 'fui-TeachingPopoverCarouselNavButton'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        cursor: 'pointer',
        boxSizing: 'border-box',
        height: '8px',
        width: '8px',
        backgroundColor: _reacttheme.tokens.colorBrandBackground
    },
    rootUnselected: {
        border: 'none',
        borderRadius: '50%',
        padding: '0px',
        outline: `${_reacttheme.tokens.strokeWidthThin} solid transparent`,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            ..._react.shorthands.borderColor('transparent')
        }),
        backgroundColor: `color-mix(in srgb, ${_reacttheme.tokens.colorBrandBackground} 30%, transparent)`,
        '@supports not (color: color-mix(in lch, white, black))': {
            // This will also affect the focus border, but only in older unsupported browsers
            opacity: 0.3,
            backgroundColor: _reacttheme.tokens.colorBrandBackground
        }
    },
    rootSelected: {
        outline: `${_reacttheme.tokens.strokeWidthThin} solid transparent`,
        width: '16px',
        border: 'none',
        borderRadius: '4px',
        padding: '0px',
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            ..._react.shorthands.borderColor('transparent')
        }),
        '@media (forced-colors: active)': {
            backgroundColor: 'CanvasText'
        }
    },
    rootBrand: {
        backgroundColor: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    rootBrandUnselected: {
        backgroundColor: `color-mix(in srgb, ${_reacttheme.tokens.colorNeutralForegroundOnBrand} 30%, transparent)`,
        '@supports not (color: color-mix(in lch, white, black))': {
            // This will also affect the focus border, but only in older unsupported browsers
            opacity: 0.3,
            backgroundColor: _reacttheme.tokens.colorBrandBackground
        }
    }
});
const useTeachingPopoverCarouselNavButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { appearance, isSelected } = state;
    const brandStyles = isSelected ? styles.rootBrand : styles.rootBrandUnselected;
    state.root.className = (0, _react.mergeClasses)(teachingPopoverCarouselNavButtonClassNames.root, styles.root, isSelected ? styles.rootSelected : styles.rootUnselected, appearance === 'brand' && brandStyles, state.root.className);
    return state;
};
