'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTeachingPopoverCarouselNavButton_unstable", {
    enumerable: true,
    get: function() {
        return useTeachingPopoverCarouselNavButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactaria = require("@fluentui/react-aria");
const _reactpopover = require("@fluentui/react-popover");
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _CarouselContext = require("../TeachingPopoverCarousel/Carousel/CarouselContext");
const _valueIdContext = require("../TeachingPopoverCarouselNav/valueIdContext");
const useTeachingPopoverCarouselNavButton_unstable = (props, ref)=>{
    const { onClick, as = 'a' } = props;
    const value = (0, _valueIdContext.useValueIdContext)();
    const appearance = (0, _reactpopover.usePopoverContext_unstable)((context)=>context.appearance);
    const selectPageByValue = (0, _CarouselContext.useCarouselContext_unstable)((c)=>c.selectPageByValue);
    const isSelected = (0, _CarouselContext.useCarouselContext_unstable)((c)=>c.value === value);
    const handleClick = (0, _reactutilities.useEventCallback)((event)=>{
        onClick === null || onClick === void 0 ? void 0 : onClick(event);
        if (!event.defaultPrevented && (0, _reactutilities.isHTMLElement)(event.target)) {
            selectPageByValue(event, value);
        }
    });
    const defaultTabProps = (0, _reacttabster.useTabsterAttributes)({
        focusable: {
            isDefault: isSelected
        }
    });
    const _carouselButton = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(as, (0, _reactaria.useARIAButtonProps)(props.as, props)), {
        elementType: 'button',
        defaultProps: {
            ref: ref,
            role: 'tab',
            type: 'button',
            'aria-selected': `${!!isSelected}`,
            ...defaultTabProps
        }
    });
    _carouselButton.onClick = handleClick;
    const state = {
        isSelected,
        appearance,
        components: {
            root: 'button'
        },
        root: _carouselButton
    };
    return state;
};
