'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCarouselWalker_unstable", {
    enumerable: true,
    get: function() {
        return useCarouselWalker_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _constants = require("./constants");
const useCarouselWalker_unstable = ()=>{
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const treeWalkerRef = _react.useRef(targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.createTreeWalker(targetDocument.body));
    const htmlRef = _react.useRef(null);
    const ref = _react.useCallback((el)=>{
        if (!targetDocument) {
            return;
        }
        if (!el) {
            return;
        }
        htmlRef.current = el;
        treeWalkerRef.current = targetDocument.createTreeWalker(el, NodeFilter.SHOW_ELEMENT, {
            acceptNode (node) {
                if (!(0, _reactutilities.isHTMLElement)(node)) {
                    return NodeFilter.FILTER_SKIP;
                }
                return node.hasAttribute(_constants.CAROUSEL_ITEM) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
            }
        });
    }, [
        targetDocument
    ]);
    return {
        ref,
        walker: _react.useMemo(()=>({
                active () {
                    if (!htmlRef.current) {
                        return null;
                    }
                    const activeEl = htmlRef.current.querySelector(`[${_constants.CAROUSEL_ACTIVE_ITEM}="true"]`);
                    if ((0, _reactutilities.isHTMLElement)(activeEl)) {
                        return {
                            el: activeEl,
                            value: activeEl.getAttribute(_constants.CAROUSEL_ITEM)
                        };
                    }
                    return null;
                },
                find (value) {
                    var _treeWalkerRef_current;
                    if (!((_treeWalkerRef_current = treeWalkerRef.current) === null || _treeWalkerRef_current === void 0 ? void 0 : _treeWalkerRef_current.currentNode) || !htmlRef.current) {
                        return null;
                    }
                    treeWalkerRef.current.currentNode = htmlRef.current;
                    let nextNode = null;
                    while(nextNode = treeWalkerRef.current.nextNode()){
                        if (!(0, _reactutilities.isHTMLElement)(nextNode)) {
                            continue;
                        }
                        if (nextNode.getAttribute(_constants.CAROUSEL_ITEM) === value) {
                            return {
                                el: nextNode,
                                value: nextNode.getAttribute(_constants.CAROUSEL_ITEM)
                            };
                        }
                    }
                    return null;
                },
                nextPage (value) {
                    var _treeWalkerRef_current;
                    const res = this.find(value);
                    if (!res || !((_treeWalkerRef_current = treeWalkerRef.current) === null || _treeWalkerRef_current === void 0 ? void 0 : _treeWalkerRef_current.currentNode)) {
                        return null;
                    }
                    treeWalkerRef.current.currentNode = res.el;
                    const next = treeWalkerRef.current.nextNode();
                    if ((0, _reactutilities.isHTMLElement)(next)) {
                        return {
                            el: next,
                            value: next.getAttribute(_constants.CAROUSEL_ITEM)
                        };
                    }
                    return null;
                },
                prevPage (value) {
                    var _treeWalkerRef_current;
                    const res = this.find(value);
                    if (!res || !((_treeWalkerRef_current = treeWalkerRef.current) === null || _treeWalkerRef_current === void 0 ? void 0 : _treeWalkerRef_current.currentNode)) {
                        return null;
                    }
                    treeWalkerRef.current.currentNode = res.el;
                    const next = treeWalkerRef.current.previousNode();
                    if ((0, _reactutilities.isHTMLElement)(next)) {
                        return {
                            el: next,
                            value: next.getAttribute(_constants.CAROUSEL_ITEM)
                        };
                    }
                    return null;
                }
            }), [])
    };
};
