"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createCarouselStore", {
    enumerable: true,
    get: function() {
        return createCarouselStore;
    }
});
const createCarouselStore = ()=>{
    let values = [];
    let listeners = [];
    const carouselStore = {
        clear () {
            values = [];
            emitChange();
        },
        addValue (value) {
            values = [
                ...values,
                value
            ];
            emitChange();
        },
        insertValue (value, prev) {
            if (!prev) {
                values = [
                    value,
                    ...values
                ];
            } else {
                const pos = values.indexOf(prev);
                values.splice(pos + 1, 0, value);
                // Required to be defined as a 'new' array for useSyncExternalStore
                values = [
                    ...values
                ];
            }
            emitChange();
        },
        removeValue (value) {
            const pos = values.indexOf(value);
            values.splice(pos, 1);
            // Required to be defined as a 'new' array for useSyncExternalStore
            values = [
                ...values
            ];
            emitChange();
        },
        subscribe (listener) {
            listeners = [
                ...listeners,
                listener
            ];
            return ()=>{
                listeners = listeners.filter((l)=>l !== listener);
            };
        },
        getSnapshot () {
            return values;
        }
    };
    function emitChange() {
        for (const listener of listeners){
            listener();
        }
    }
    return carouselStore;
};
