'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCarouselItem_unstable", {
    enumerable: true,
    get: function() {
        return useCarouselItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _CarouselContext = require("../CarouselContext");
const _constants = require("../constants");
const useCarouselItem_unstable = (props, ref)=>{
    const { value } = props;
    const visible = (0, _CarouselContext.useCarouselContext_unstable)((c)=>c.value === value);
    const state = {
        value,
        visible,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            [_constants.CAROUSEL_ITEM]: value,
            [_constants.CAROUSEL_ACTIVE_ITEM]: visible,
            hidden: !visible,
            ...props
        }), {
            elementType: 'div'
        })
    };
    if (!visible) {
        state.root.children = null;
    }
    return state;
};
