'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCarousel_unstable", {
    enumerable: true,
    get: function() {
        return useCarousel_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _constants = require("./constants");
const _useCarouselWalker = require("./useCarouselWalker");
const _createCarouselStore = require("./createCarouselStore");
function useCarousel_unstable(options) {
    'use no memo';
    const { announcement, onValueChange, onFinish } = options;
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const win = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
    const { ref: carouselRef, walker: carouselWalker } = (0, _useCarouselWalker.useCarouselWalker_unstable)();
    const [store] = _react.useState(()=>(0, _createCarouselStore.createCarouselStore)());
    const [value, setValue] = (0, _reactutilities.useControllableState)({
        defaultState: options.defaultValue,
        state: options.value,
        initialState: null
    });
    const rootRef = _react.useRef(null);
    const { announce } = (0, _reactsharedcontexts.useAnnounce)();
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        _react.useEffect(()=>{
            if (value === null) {
                // eslint-disable-next-line no-console
                console.error('useCarousel: Carousel needs to have a `defaultValue` or `value` prop set. If you want to control the value, use the `value` prop.');
            }
        }, [
            value
        ]);
    }
    _react.useEffect(()=>{
        var _rootRef_current;
        const allItems = (_rootRef_current = rootRef.current) === null || _rootRef_current === void 0 ? void 0 : _rootRef_current.querySelectorAll(`[${_constants.CAROUSEL_ITEM}]`);
        for(let i = 0; i < allItems.length; i++){
            store.addValue(allItems.item(i).getAttribute(_constants.CAROUSEL_ITEM));
        }
        return ()=>{
            store.clear();
        };
    }, [
        store
    ]);
    _react.useEffect(()=>{
        if (!win) {
            return;
        }
        const config = {
            attributes: true,
            attributeFilter: [
                _constants.CAROUSEL_ITEM
            ],
            childList: true,
            subtree: true
        };
        // Callback function to execute when mutations are observed
        const callback = (mutationList)=>{
            for (const mutation of mutationList){
                for (const addedNode of Array.from(mutation.addedNodes)){
                    if ((0, _reactutilities.isHTMLElement)(addedNode) && addedNode.hasAttribute(_constants.CAROUSEL_ITEM)) {
                        const newValue = addedNode.getAttribute(_constants.CAROUSEL_ITEM);
                        const newNode = carouselWalker.find(newValue);
                        if (!(newNode === null || newNode === void 0 ? void 0 : newNode.value)) {
                            return;
                        }
                        const previousNode = carouselWalker.prevPage(newNode === null || newNode === void 0 ? void 0 : newNode.value);
                        var _previousNode_value;
                        store.insertValue(newValue, (_previousNode_value = previousNode === null || previousNode === void 0 ? void 0 : previousNode.value) !== null && _previousNode_value !== void 0 ? _previousNode_value : null);
                    }
                }
                for (const removedNode of Array.from(mutation.removedNodes)){
                    if ((0, _reactutilities.isHTMLElement)(removedNode) && (removedNode === null || removedNode === void 0 ? void 0 : removedNode.hasAttribute(_constants.CAROUSEL_ITEM))) {
                        const removedValue = removedNode.getAttribute(_constants.CAROUSEL_ITEM);
                        store.removeValue(removedValue);
                    }
                }
            }
        };
        // Create an observer instance linked to the callback function
        const observer = new win.MutationObserver(callback);
        // Start observing the target node for configured mutations
        observer.observe(rootRef.current, config);
        // Later, you can stop observing
        return ()=>{
            observer.disconnect();
        };
    }, [
        carouselWalker,
        store,
        win
    ]);
    const updateSlide = (0, _reactutilities.useEventCallback)((event, newValue)=>{
        setValue(newValue);
        onValueChange === null || onValueChange === void 0 ? void 0 : onValueChange(event, {
            event,
            type: 'click',
            value: newValue
        });
        const announceText = announcement === null || announcement === void 0 ? void 0 : announcement(newValue);
        if (announceText) {
            announce(announceText, {
                polite: true
            });
        }
    });
    const selectPageByDirection = (0, _reactutilities.useEventCallback)((event, direction)=>{
        const active = carouselWalker.active();
        if (!(active === null || active === void 0 ? void 0 : active.value)) {
            return;
        }
        const newPage = direction === 'prev' ? carouselWalker.prevPage(active.value) : carouselWalker.nextPage(active.value);
        if (newPage) {
            updateSlide(event, newPage === null || newPage === void 0 ? void 0 : newPage.value);
        } else {
            onFinish === null || onFinish === void 0 ? void 0 : onFinish(event, {
                event,
                type: 'click',
                value: active === null || active === void 0 ? void 0 : active.value
            });
        }
    });
    return {
        carouselRef: (0, _reactutilities.useMergedRefs)(rootRef, carouselRef),
        carousel: {
            store,
            value,
            selectPageByDirection,
            selectPageByValue: updateSlide
        }
    };
}
