'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    teachingPopoverBodyClassNames: function() {
        return teachingPopoverBodyClassNames;
    },
    useMediaStyles: function() {
        return useMediaStyles;
    },
    useTeachingPopoverBodyStyles_unstable: function() {
        return useTeachingPopoverBodyStyles_unstable;
    }
});
const _react = require("@griffel/react");
const teachingPopoverBodyClassNames = {
    root: 'fui-TeachingPopoverBody',
    media: 'fui-TeachingPopoverBody__media'
};
const popoverBodyDimension = 288;
const useMediaStyles = (0, _react.makeStyles)({
    base: {
        gridArea: 'media',
        overflow: 'hidden',
        width: 'auto',
        marginBottom: '12px',
        verticalAlign: 'middle',
        justifyContent: 'center',
        display: 'flex'
    },
    short: {
        aspectRatio: popoverBodyDimension / 117,
        '@supports not (aspect-ratio)': {
            height: '117px'
        }
    },
    medium: {
        aspectRatio: popoverBodyDimension / 176,
        '@supports not (aspect-ratio)': {
            height: '176px'
        }
    },
    tall: {
        aspectRatio: 1,
        '@supports not (aspect-ratio)': {
            height: `${popoverBodyDimension}px`
        }
    }
});
const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'column',
        paddingBottom: '12px'
    }
});
const useTeachingPopoverBodyStyles_unstable = (state)=>{
    'use no memo';
    const { mediaLength } = state;
    const styles = useStyles();
    const mediaStyles = useMediaStyles();
    state.root.className = (0, _react.mergeClasses)(teachingPopoverBodyClassNames.root, styles.root, state.root.className);
    if (state.media) {
        state.media.className = (0, _react.mergeClasses)(teachingPopoverBodyClassNames.media, mediaStyles.base, mediaStyles[mediaLength], state.media.className);
    }
    return state;
};
