import { ARIAButtonSlotProps } from '@fluentui/react-aria';
import { Button } from '@fluentui/react-button';
import { ButtonProps } from '@fluentui/react-button';
import { ButtonState } from '@fluentui/react-button';
import { ComponentProps } from '@fluentui/react-utilities';
import { ComponentState } from '@fluentui/react-utilities';
import { EventData } from '@fluentui/react-utilities';
import { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import { JSXElement } from '@fluentui/react-utilities';
import { PopoverContextValue } from '@fluentui/react-popover';
import type { PopoverProps } from '@fluentui/react-popover';
import { PopoverState } from '@fluentui/react-popover';
import { PopoverSurfaceSlots } from '@fluentui/react-popover';
import { PopoverSurfaceState } from '@fluentui/react-popover';
import { PopoverTriggerChildProps } from '@fluentui/react-popover';
import { PopoverTriggerProps } from '@fluentui/react-popover';
import { PopoverTriggerState } from '@fluentui/react-popover';
import * as React_2 from 'react';
import { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

declare type CarouselContextValue = {
    store: CarouselStore;
    value: string | null;
    selectPageByDirection: (event: React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>, direction: 'next' | 'prev') => void;
    selectPageByValue: (event: React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>, value: string) => void;
};

declare type CarouselItemProps = ComponentProps<CarouselItemSlots> & {
    /**
     * The value used to identify a page,
     * it should be unique and is necessary for pagination
     */
    value: string;
};

declare type CarouselItemSlots = {
    /**
     * The element wrapping carousel pages and navigation.
     */
    root: NonNullable<Slot<'div'>>;
};

declare type CarouselStore = {
    clear: () => void;
    addValue: (value: string) => void;
    insertValue: (value: string, prev: string | null) => void;
    removeValue: (value: string) => void;
    subscribe: (listener: () => void) => () => void;
    getSnapshot: () => string[];
};

declare type CarouselValueChangeData = EventData<'click', React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>> & {
    /**
     * The value to be set after event has occurred.
     */
    value?: string;
};

declare type NavButtonRenderFunction = (value: string) => React_2.ReactNode;

/**
 * Render the final JSX of TeachingPopover
 */
export declare const renderTeachingPopover_unstable: (state: PopoverState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverBody
 */
export declare const renderTeachingPopoverBody_unstable: (state: TeachingPopoverBodyState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarousel
 */
export declare const renderTeachingPopoverCarousel_unstable: (state: TeachingPopoverCarouselState, contextValues: TeachingPopoverCarouselContextValues) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarouselCard
 */
export declare const renderTeachingPopoverCarouselCard_unstable: (state: TeachingPopoverCarouselCardState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarouselFooter
 */
export declare const renderTeachingPopoverCarouselFooter_unstable: (state: TeachingPopoverCarouselFooterState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarouselFooterButton
 */
export declare const renderTeachingPopoverCarouselFooterButton_unstable: (state: TeachingPopoverCarouselFooterButtonState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarouselNav
 */
export declare const renderTeachingPopoverCarouselNav_unstable: (state: TeachingPopoverCarouselNavState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarouselNavButton
 */
export declare const renderTeachingPopoverCarouselNavButton_unstable: (state: TeachingPopoverCarouselNavButtonState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverCarouselPageCount
 */
export declare const renderTeachingPopoverCarouselPageCount_unstable: (state: TeachingPopoverCarouselPageCountState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverFooter
 */
export declare const renderTeachingPopoverFooter_unstable: (state: TeachingPopoverFooterState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverHeader
 */
export declare const renderTeachingPopoverHeader_unstable: (state: TeachingPopoverHeaderState) => JSXElement;

/**
 * Render the final JSX of PopoverSurface
 */
export declare const renderTeachingPopoverSurface_unstable: (state: TeachingPopoverSurfaceState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverTitle
 */
export declare const renderTeachingPopoverTitle_unstable: (state: TeachingPopoverTitleState) => JSXElement;

/**
 * Render the final JSX of TeachingPopoverTrigger
 */
export declare const renderTeachingPopoverTrigger_unstable: (state: TeachingPopoverTriggerState) => JSXElement | null;

/**
 * An extension class of Popover which defaults to withArrow and FocusTrap enabled.
 */
export declare const TeachingPopover: React_2.FC<TeachingPopoverProps>;

/**
 * Define a styled TeachingPopoverBody, using the `useTeachingPopoverBody_unstable` and `useTeachingPopoverBodyStyles_unstable`
 * hooks.
 *
 * TeachingPopoverBody is used to host content within a TeachingPopover, and provides a standardized media slot
 */
export declare const TeachingPopoverBody: ForwardRefComponent<TeachingPopoverBodyProps>;

export declare const teachingPopoverBodyClassNames: SlotClassNames<TeachingPopoverBodySlots>;

export declare type TeachingPopoverBodyProps = ComponentProps<TeachingPopoverBodySlots> & {
    mediaLength?: 'short' | 'medium' | 'tall';
};

export declare type TeachingPopoverBodySlots = {
    /**
     * The element wrapping the buttons.
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * Optional Media Content.
     */
    media?: Slot<'span'>;
};

export declare type TeachingPopoverBodyState = ComponentState<TeachingPopoverBodySlots> & Required<Pick<TeachingPopoverBodyProps, 'mediaLength'>>;

/**
 * Define a styled TeachingPopoverCarousel, using the `useTeachingPopoverCarousel_unstable` and `useTeachingPopoverCarouselStyles_unstable`
 * hooks.
 *
 * TeachingPopoverCarousel injects context providers that are required for TeachingPopoverCarouselCard display and navigation functionality
 */
export declare const TeachingPopoverCarousel: ForwardRefComponent<TeachingPopoverCarouselProps>;

/**
 * Define a styled TeachingPopoverCarouselCard, using the `useTeachingPopoverCarouselCard_unstable` and `useTeachingPopoverCarouselCardStyles_unstable`
 * hooks.
 *
 * TeachingPopoverCarouselCard is the definition of a single page view within the carousel, they are shown one at a time and can be navigated through sequentially.
 */
export declare const TeachingPopoverCarouselCard: ForwardRefComponent<TeachingPopoverCarouselCardProps>;

export declare const teachingPopoverCarouselCardClassNames: SlotClassNames<TeachingPopoverCarouselCardSlots>;

export declare type TeachingPopoverCarouselCardProps = ComponentProps<TeachingPopoverCarouselCardSlots> & {
    value: string;
};

export declare type TeachingPopoverCarouselCardSlots = {
    /**
     * The element wrapping the buttons.
     */
    root: NonNullable<Slot<CarouselItemProps>>;
};

export declare type TeachingPopoverCarouselCardState = ComponentState<TeachingPopoverCarouselCardSlots> & Required<Pick<TeachingPopoverCarouselCardProps, 'value'>>;

export declare const teachingPopoverCarouselClassNames: SlotClassNames<TeachingPopoverCarouselSlots>;

/**
 * Context shared between TeachingPopoverCarousel and its children components
 */
declare type TeachingPopoverCarouselContextValues = {
    carousel: CarouselContextValue;
};

/**
 * Define a styled TeachingPopoverCarouselFooter, using the `useTeachingPopoverCarouselFooter_unstable` and `useTeachingPopoverCarouselFooterStyles_unstable`
 * hooks.
 *
 * TeachingPopoverCarouselFooter contains previous/next buttons configured for carousel navigation, and a root slot for page count and/or page index navigation.
 */
export declare const TeachingPopoverCarouselFooter: ForwardRefComponent<TeachingPopoverCarouselFooterProps>;

/**
 * TeachingPopoverCarouselFooterButton component
 *
 * TeachingPopoverCarouselFooterButton extends Button and injects additional styling and onClick functionality
 * to match the context provided by TeachingPopover & TeachingPopoverCarousel
 */
export declare const TeachingPopoverCarouselFooterButton: ForwardRefComponent<TeachingPopoverCarouselFooterButtonProps>;

export declare const teachingPopoverCarouselFooterButtonClassNames: SlotClassNames<TeachingPopoverCarouselFooterButtonSlots>;

/**
 * TeachingPopoverCarouselFooterButton Props
 */
export declare type TeachingPopoverCarouselFooterButtonProps = ComponentProps<TeachingPopoverCarouselFooterButtonSlots> & ButtonProps & {
    /**
     * Defines whether the button should be next or previous type - used for both styling and functionality.
     */
    navType: 'next' | 'prev';
    /**
     * The ReactNode provided to the button when it is on it's first (navType 'prev') or last (navType 'next') step
     */
    altText: React_2.ReactNode;
};

export declare type TeachingPopoverCarouselFooterButtonSlots = {
    root: NonNullable<Slot<ARIAButtonSlotProps<'a'>>>;
};

/**
 * State used in rendering TeachingPopoverCarouselFooterButton
 */
export declare type TeachingPopoverCarouselFooterButtonState = ButtonState & ComponentState<TeachingPopoverCarouselFooterButtonSlots> & Pick<TeachingPopoverCarouselFooterButtonProps, 'navType' | 'altText'> & {
    popoverAppearance: PopoverContextValue['appearance'];
};

export declare const teachingPopoverCarouselFooterClassNames: SlotClassNames<TeachingPopoverCarouselFooterSlots>;

declare type TeachingPopoverCarouselFooterLayout = 'offset' | 'centered';

/**
 * TeachingPopoverCarouselFooter Props
 */
export declare type TeachingPopoverCarouselFooterProps = ComponentProps<TeachingPopoverCarouselFooterSlots> & {
    /**
     * Controls whether buttons will be centered (balanced) or right aligned
     * Defaults to 'centered'.
     */
    layout?: TeachingPopoverCarouselFooterLayout;
    /**
     * The text to be displayed on the initial step of carousel
     */
    initialStepText: string;
    /**
     * The text to be displayed on the final step of carousel
     */
    finalStepText: string;
};

export declare type TeachingPopoverCarouselFooterSlots = {
    /**
     * The element wrapping carousel pages and navigation.
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * The previous button slot.
     */
    previous?: Slot<TeachingPopoverCarouselFooterButtonProps>;
    /**
     * The next button slot.
     */
    next: NonNullable<Slot<TeachingPopoverCarouselFooterButtonProps>>;
};

/**
 * TeachingPopoverCarouselFooter State and Context Hooks
 */
export declare type TeachingPopoverCarouselFooterState = ComponentState<Required<TeachingPopoverCarouselFooterSlots>> & Pick<TeachingPopoverCarouselFooterProps, 'layout'>;

/**
 * Define a styled TeachingPopoverCarouselNav, using the `useTeachingPopoverCarouselNav_unstable` and `useTeachingPopoverCarouselNavStyles_unstable`
 * hooks.
 *
 * TeachingPopoverCarouselNav provides an index-based pagination list to jump to any page within the carousel.
 */
export declare const TeachingPopoverCarouselNav: ForwardRefComponent<TeachingPopoverCarouselNavProps>;

/**
 * TeachingPopoverCarouselNavButton is a button to jump to a single page within TeachingPopoverCarousel
 *
 * It's value is injected via context and must be wrapped with a ValueIdContextProvider (automatically handled via TeachingPopoverCarouselNav)
 */
export declare const TeachingPopoverCarouselNavButton: ForwardRefComponent<TeachingPopoverCarouselNavButtonProps>;

export declare const teachingPopoverCarouselNavButtonClassNames: SlotClassNames<TeachingPopoverCarouselNavButtonSlots>;

/**
 * TeachingPopoverCarouselNavButton Props
 */
export declare type TeachingPopoverCarouselNavButtonProps = ComponentProps<TeachingPopoverCarouselNavButtonSlots>;

export declare type TeachingPopoverCarouselNavButtonSlots = {
    /**
     * ARIA compliant nav buttons used to jump to pages
     */
    root: NonNullable<Slot<ARIAButtonSlotProps<'a'>>>;
};

/**
 * TeachingPopoverCarouselNavButton State
 */
export declare type TeachingPopoverCarouselNavButtonState = ComponentState<TeachingPopoverCarouselNavButtonSlots> & {
    /**
     * Enables selection state control
     */
    isSelected?: boolean;
} & Pick<PopoverContextValue, 'appearance'>;

export declare const teachingPopoverCarouselNavClassNames: SlotClassNames<TeachingPopoverCarouselNavSlots>;

export declare type TeachingPopoverCarouselNavProps = Omit<ComponentProps<Partial<TeachingPopoverCarouselNavSlots>>, 'children'> & {
    children: NavButtonRenderFunction;
};

export declare type TeachingPopoverCarouselNavSlots = {
    /**
     * The element wrapping the carousel pagination. By default this is a div,
     * it may contain icons or text depending on TeachingPopoverCarouselNavStyle
     */
    root: NonNullable<Slot<'div'>>;
};

export declare type TeachingPopoverCarouselNavState = ComponentState<TeachingPopoverCarouselNavSlots> & {
    values: string[];
    renderNavButton: NavButtonRenderFunction;
};

/**
 * TeachingPopoverCarouselPageCount is a simple interface for rendering based on current and total page count
 *
 * The child render function will provide both current and total page numbers for customization.
 */
export declare const TeachingPopoverCarouselPageCount: ForwardRefComponent<TeachingPopoverCarouselPageCountProps>;

export declare const teachingPopoverCarouselPageCountClassNames: SlotClassNames<TeachingPopoverCarouselPageCountSlots>;

/**
 * TeachingPopoverCarouselPageCount Props
 */
export declare type TeachingPopoverCarouselPageCountProps = Omit<ComponentProps<Partial<TeachingPopoverCarouselPageCountSlots>>, 'children'> & {
    children: TeachingPopoverCarouselPageCountRenderFunction;
};

export declare type TeachingPopoverCarouselPageCountRenderFunction = (currentPage: number, totalPages: number) => React_2.ReactNode;

export declare type TeachingPopoverCarouselPageCountSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering TeachingPopoverCarouselPageCount
 */
export declare type TeachingPopoverCarouselPageCountState = ComponentState<TeachingPopoverCarouselPageCountSlots> & {
    currentIndex: number;
    totalPages: number;
    renderPageCount: TeachingPopoverCarouselPageCountRenderFunction;
};

/**
 * TeachingPopoverCarousel Props
 */
export declare type TeachingPopoverCarouselProps = ComponentProps<TeachingPopoverCarouselSlots> & UseCarouselOptions;

export declare type TeachingPopoverCarouselSlots = {
    /**
     * The element wrapping carousel pages and navigation.
     */
    root: NonNullable<Slot<'div'>>;
};

/**
 * TeachingPopoverCarousel State and Context Hooks
 */
export declare type TeachingPopoverCarouselState = ComponentState<Required<TeachingPopoverCarouselSlots>> & Partial<Pick<PopoverContextValue, 'appearance'>> & CarouselContextValue;

/**
 * Define a styled TeachingPopoverFooter, using the `useTeachingPopoverFooter_unstable` and `useTeachingPopoverFooterStyles_unstable`
 * hooks.
 *
 * TeachingPopoverFooter will provide both a secondary and primary button for the TeachingPopover,
 * and handle Popover functionality such as closing the popup.
 *
 * Users must provide the localized text for each button within the footer via slots.
 */
export declare const TeachingPopoverFooter: ForwardRefComponent<TeachingPopoverFooterProps>;

export declare const teachingPopoverFooterClassNames: SlotClassNames<TeachingPopoverFooterSlots>;

export declare type TeachingPopoverFooterProps = ComponentProps<TeachingPopoverFooterSlots> & Pick<TeachingPopoverFooterState, 'footerLayout'>;

declare type TeachingPopoverFooterSlots = {
    /**
     * The element wrapping the buttons.
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * The primary button slot.
     */
    primary: NonNullable<Slot<typeof Button>>;
    /**
     * The secondary button slot.
     */
    secondary?: Slot<typeof Button>;
};

export declare type TeachingPopoverFooterState = ComponentState<TeachingPopoverFooterSlots> & Pick<PopoverContextValue, 'appearance'> & {
    /**
     * Enables stylization to a horizontal or vertical stack of button layouts.
     * Defaults to horizontal
     */
    footerLayout?: 'horizontal' | 'vertical';
};

/**
 * Define a styled TeachingPopoverHeader, using the `useTeachingPopoverHeader_unstable` and `useTeachingPopoverHeaderStyles_unstable`
 * hooks.
 *
 * TeachingPopoverHeader is an info subtitle located at the top of the popover, it provides a dismiss button by default (can be nulled)
 * and an info-tip icon that can be overridden or removed, subtitle displayed will be the children elements of TeachingPopoverHeader.
 */
export declare const TeachingPopoverHeader: ForwardRefComponent<TeachingPopoverHeaderProps>;

export declare const teachingPopoverHeaderClassNames: SlotClassNames<TeachingPopoverHeaderSlots>;

export declare type TeachingPopoverHeaderProps = ComponentProps<TeachingPopoverHeaderSlots>;

export declare type TeachingPopoverHeaderSlots = {
    /**
     * The element wrapping the text and close button. By default this is an div; although it can be a heading, this should not be done.
     * Instead, wrap the child text in a heading tag if one is needed.
     * Be sure to include role and aria heading level if div is used.
     */
    root: Slot<'div', 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6'>;
    /**
     * The component to be used as close button in heading
     */
    dismissButton?: Slot<'button'>;
    /**
     * Initial icon slot rendered before children content in heading.
     */
    icon?: Slot<'div'>;
};

export declare type TeachingPopoverHeaderState = ComponentState<TeachingPopoverHeaderSlots> & Pick<PopoverContextValue, 'appearance'>;

/**
 * TeachingPopover Props
 */
export declare type TeachingPopoverProps = PopoverProps;

/**
 * TeachingPopover State
 */
export declare type TeachingPopoverState = PopoverState;

/**
 * TeachingPopoverSurface component renders react children in a positioned box
 *
 * TeachingPopoverSurface is a direct extension of PopoverSurface, with it's own styling context hooks available.
 */
export declare const TeachingPopoverSurface: ForwardRefComponent<TeachingPopoverSurfaceProps>;

export declare const teachingPopoverSurfaceClassNames: SlotClassNames<TeachingPopoverSurfaceSlots>;

/**
 * TeachingPopoverSurface Props
 */
export declare type TeachingPopoverSurfaceProps = ComponentProps<TeachingPopoverSurfaceSlots>;

/**
 * Names of the slots in TeachingPopoverSurface
 */
export declare type TeachingPopoverSurfaceSlots = PopoverSurfaceSlots;

/**
 * TeachingPopoverSurface State
 */
export declare type TeachingPopoverSurfaceState = PopoverSurfaceState;

/**
 * Define a styled TeachingPopoverTitle, using the `useTeachingPopoverTitle_unstable` and `useTeachingPopoverTitleStyles_unstable`
 * hooks.
 *
 * TeachingPopoverTitle is similar to TeachingPopoverHeader, but it is intended to be placed within a TeachingPopoverBody
 * TeachingPopoverTitle can also optionally render a dismiss button, however this should only be enabled when there is no TeachingPopoverHeader/dismiss.
 */
export declare const TeachingPopoverTitle: ForwardRefComponent<TeachingPopoverTitleProps>;

export declare const teachingPopoverTitleClassNames: SlotClassNames<TeachingPopoverTitleSlots>;

/**
 * TeachingPopoverTitle Props
 */
export declare type TeachingPopoverTitleProps = ComponentProps<TeachingPopoverTitleSlots>;

export declare type TeachingPopoverTitleSlots = {
    /**
     * Title for teaching bubble
     */
    root: Slot<'h2', 'h1' | 'h3' | 'h4' | 'h5' | 'h6' | 'div'>;
    /**
     * An alternate close button path if not placed in the TeachingPopoverHeader
     */
    dismissButton?: Slot<'button'>;
};

/**
 * State used in rendering TeachingPopoverTitle
 */
export declare type TeachingPopoverTitleState = ComponentState<TeachingPopoverTitleSlots> & Pick<PopoverContextValue, 'appearance'>;

/**
 * Direct extension of PopoverTrigger - Wraps a trigger element as an only child and adds the necessary event handling to open a teaching bubble.
 */
export declare const TeachingPopoverTrigger: React_2.FC<TeachingPopoverTriggerProps>;

/**
 * Props that are passed to the child of the DialogTrigger when cloned to ensure correct behavior for the Dialog
 */
export declare type TeachingPopoverTriggerChildProps = PopoverTriggerChildProps;

/**
 * TeachingPopoverTrigger Props
 */
export declare type TeachingPopoverTriggerProps = PopoverTriggerProps;

/**
 * TeachingPopoverTrigger State
 */
export declare type TeachingPopoverTriggerState = PopoverTriggerState;

declare type UseCarouselOptions = {
    /**
     * Localizes the string used to announce carousel page changes to screen reader users
     * Defaults to: undefined
     */
    announcement?: (newValue: string) => string;
    /**
     * The initial page to display in uncontrolled mode.
     */
    defaultValue?: string;
    /**
     * The value of the currently active page.
     */
    value?: string;
    /**
     * Callback to notify a page change.
     */
    onValueChange?: EventHandler<CarouselValueChangeData>;
    /**
     * Callback to notify when the final button step of a carousel has been activated.
     */
    onFinish?: EventHandler<CarouselValueChangeData>;
};

export declare const useTeachingPopover_unstable: (props: TeachingPopoverProps) => TeachingPopoverState;

/**
 * Returns the props and state required to render the component
 * @param props - TeachingPopoverBody properties
 * @param ref - reference to root HTMLElement of TeachingPopoverBody
 */
export declare const useTeachingPopoverBody_unstable: (props: TeachingPopoverBodyProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverBodyState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverBodyStyles_unstable: (state: TeachingPopoverBodyState) => TeachingPopoverBodyState;

export declare const useTeachingPopoverCarousel_unstable: (props: TeachingPopoverCarouselProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverCarouselState;

/**
 * Returns the props and state required to render the component
 * @param props - TeachingPopoverCarouselCard properties
 * @param ref - reference to root HTMLElement of TeachingPopoverCarouselCard
 */
export declare const useTeachingPopoverCarouselCard_unstable: (props: TeachingPopoverCarouselCardProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverCarouselCardState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverCarouselCardStyles_unstable: (state: TeachingPopoverCarouselCardState) => TeachingPopoverCarouselCardState;

export declare function useTeachingPopoverCarouselContextValues_unstable(state: TeachingPopoverCarouselState): TeachingPopoverCarouselContextValues;

export declare const useTeachingPopoverCarouselFooter_unstable: (props: TeachingPopoverCarouselFooterProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverCarouselFooterState;

/**
 * Create the state required to render TeachingPopoverCarouselFooterButton.
 *
 * The returned state can be modified with hooks such as useTeachingPopoverCarouselFooterButtonStyles_unstable,
 * before being passed to renderTeachingPopoverCarouselFooterButton_unstable.
 *
 * @param props - props from this instance of TeachingPopoverCarouselFooterButton
 * @param ref - reference to root HTMLDivElement of TeachingPopoverCarouselFooterButton
 */
export declare const useTeachingPopoverCarouselFooterButton_unstable: (props: TeachingPopoverCarouselFooterButtonProps, ref: React_2.Ref<HTMLButtonElement | HTMLAnchorElement>) => TeachingPopoverCarouselFooterButtonState;

/**
 * Apply styling to the TeachingPopoverCarouselFooterButton slots based on the state
 */
export declare const useTeachingPopoverCarouselFooterButtonStyles_unstable: (state: TeachingPopoverCarouselFooterButtonState) => TeachingPopoverCarouselFooterButtonState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverCarouselFooterStyles_unstable: (state: TeachingPopoverCarouselFooterState) => TeachingPopoverCarouselFooterState;

/**
 * Returns the props and state required to render the component
 * @param props - TeachingPopoverCarouselNav properties
 * @param ref - reference to root HTMLElement of TeachingPopoverCarouselNav
 */
export declare const useTeachingPopoverCarouselNav_unstable: (props: TeachingPopoverCarouselNavProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverCarouselNavState;

/**
 * Create the state required to render TeachingPopoverCarouselNavButton.
 *
 * The returned state can be modified with hooks such as useTeachingPopoverCarouselNavButtonStyles_unstable,
 * before being passed to renderTeachingPopoverCarouselNavButton_unstable.
 *
 * @param props - props from this instance of TeachingPopoverCarouselNavButton
 * @param ref - reference to root HTMLElement of TeachingPopoverCarouselNavButton
 */
export declare const useTeachingPopoverCarouselNavButton_unstable: (props: TeachingPopoverCarouselNavButtonProps, ref: React_2.Ref<HTMLButtonElement | HTMLAnchorElement>) => TeachingPopoverCarouselNavButtonState;

/**
 * Apply styling to the TeachingPopoverCarouselNavButton slots based on the state
 */
export declare const useTeachingPopoverCarouselNavButtonStyles_unstable: (state: TeachingPopoverCarouselNavButtonState) => TeachingPopoverCarouselNavButtonState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverCarouselNavStyles_unstable: (state: TeachingPopoverCarouselNavState) => TeachingPopoverCarouselNavState;

/**
 * Create the state required to render TeachingPopoverCarouselPageCount.
 *
 * The returned state can be modified with hooks such as useTeachingPopoverCarouselPageCountStyles_unstable,
 * before being passed to renderTeachingPopoverCarouselPageCount_unstable.
 *
 * @param props - props from this instance of TeachingPopoverCarouselPageCount
 * @param ref - reference to root HTMLDivElement of TeachingPopoverCarouselPageCount
 */
export declare const useTeachingPopoverCarouselPageCount_unstable: (props: TeachingPopoverCarouselPageCountProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverCarouselPageCountState;

/**
 * Apply styling to the TeachingPopoverCarouselPageCount slots based on the state
 */
export declare const useTeachingPopoverCarouselPageCountStyles_unstable: (state: TeachingPopoverCarouselPageCountState) => TeachingPopoverCarouselPageCountState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverCarouselStyles_unstable: (state: TeachingPopoverCarouselState) => TeachingPopoverCarouselState;

/**
 * Returns the props and state required to render the component
 * @param props - TeachingPopoverFooter properties
 * @param ref - reference to root HTMLElement of TeachingPopoverFooter
 */
export declare const useTeachingPopoverFooter_unstable: (props: TeachingPopoverFooterProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverFooterState;

/**
 * Returns the props and state required to render the component
 * @param props - TeachingPopoverHeader properties
 * @param ref - reference to root HTMLElement of TeachingPopoverHeader
 */
export declare const useTeachingPopoverHeader_unstable: (props: TeachingPopoverHeaderProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverHeaderState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverHeaderStyles_unstable: (state: TeachingPopoverHeaderState) => TeachingPopoverHeaderState;

/**
 * Create the state required to render TeachingPopoverSurface.
 *
 * The returned state can be modified with hooks such as useTeachingPopoverSurfaceStyles_unstable,
 * before being passed to renderTeachingPopoverSurface_unstable.
 *
 * @param props - props from this instance of TeachingPopoverSurface
 * @param ref - reference to root HTMLDivElement of TeachingPopoverSurface
 */
export declare const useTeachingPopoverSurface_unstable: (props: TeachingPopoverSurfaceProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverSurfaceState;

/**
 * Apply styling to the TeachingPopoverSurface slots based on the state
 */
export declare const useTeachingPopoverSurfaceStyles_unstable: (state: TeachingPopoverSurfaceState) => TeachingPopoverSurfaceState;

/**
 * Returns the props and state required to render the component
 * @param props - TeachingPopoverTitle properties
 * @param ref - reference to root HTMLElement of TeachingPopoverTitle
 */
export declare const useTeachingPopoverTitle_unstable: (props: TeachingPopoverTitleProps, ref: React_2.Ref<HTMLDivElement>) => TeachingPopoverTitleState;

/** Applies style classnames to slots */
export declare const useTeachingPopoverTitleStyles_unstable: (state: TeachingPopoverTitleState) => TeachingPopoverTitleState;

/**
 * Create the state required to render TeachingPopoverTrigger.
 *
 * @param props - props from this instance of TeachingPopoverTrigger
 */
export declare const useTeachingPopoverTrigger_unstable: (props: TeachingPopoverTriggerProps) => TeachingPopoverTriggerState;

export { }
