'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
export const tagGroupClassNames = {
  root: 'fui-TagGroup'
};
/**
 * Styles for the root slot
 */
const useRootStyles = /*#__PURE__*/__styles({
  base: {
    mc9l5x: "ftuwxu6"
  },
  medium: {
    i8kkvl: "fsnqrgy"
  },
  small: {
    i8kkvl: "f1rjii52"
  },
  "extra-small": {
    i8kkvl: "f1ufnopg"
  }
}, {
  d: [".ftuwxu6{display:inline-flex;}", ".fsnqrgy{column-gap:var(--spacingHorizontalS);}", ".f1rjii52{column-gap:var(--spacingHorizontalSNudge);}", ".f1ufnopg{column-gap:var(--spacingHorizontalXS);}"]
});
/**
 * Apply styling to the TagGroup slots based on the state
 */
export const useTagGroupStyles_unstable = state => {
  'use no memo';

  const styles = useRootStyles();
  const {
    size
  } = state;
  state.root.className = mergeClasses(tagGroupClassNames.root, styles.base, styles[size], state.root.className);
  return state;
};