'use client';
import * as React from 'react';
import { getIntrinsicElementProps, useEventCallback, slot, useId } from '@fluentui/react-utilities';
import { Delete, Backspace } from '@fluentui/keyboard-keys';
import { DismissRegular } from '@fluentui/react-icons';
import { useInteractionTagContext_unstable } from '../../contexts/interactionTagContext';
/**
 * Create the state required to render InteractionTagSecondary.
 *
 * The returned state can be modified with hooks such as useInteractionTagSecondaryStyles_unstable,
 * before being passed to renderInteractionTagSecondary_unstable.
 *
 * @param props - props from this instance of InteractionTagSecondary
 * @param ref - reference to root HTMLButtonElement of InteractionTagSecondary
 */ export const useInteractionTagSecondary_unstable = (props, ref)=>{
    const { appearance, disabled, handleTagDismiss, interactionTagPrimaryId, selected, shape, size, value } = useInteractionTagContext_unstable();
    const id = useId('fui-InteractionTagSecondary-', props.id);
    const onClick = useEventCallback((ev)=>{
        var _props_onClick;
        props === null || props === void 0 ? void 0 : (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, ev);
        if (!ev.defaultPrevented) {
            handleTagDismiss === null || handleTagDismiss === void 0 ? void 0 : handleTagDismiss(ev, {
                value
            });
        }
    });
    const onKeyDown = useEventCallback((ev)=>{
        var _props_onKeyDown;
        props === null || props === void 0 ? void 0 : (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, ev);
        if (!ev.defaultPrevented && (ev.key === Delete || ev.key === Backspace)) {
            handleTagDismiss === null || handleTagDismiss === void 0 ? void 0 : handleTagDismiss(ev, {
                value
            });
        }
    });
    return {
        appearance,
        disabled,
        selected,
        shape,
        size,
        components: {
            root: 'button'
        },
        root: slot.always(getIntrinsicElementProps('button', {
            children: /*#__PURE__*/ React.createElement(DismissRegular, null),
            type: 'button',
            disabled,
            ref,
            'aria-labelledby': `${interactionTagPrimaryId} ${id}`,
            ...props,
            id,
            onClick,
            onKeyDown
        }), {
            elementType: 'button'
        })
    };
};
