'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
export const interactionTagClassNames = {
  root: 'fui-InteractionTag'
};
const useRootBaseClassName = /*#__PURE__*/__resetStyles("r1y684pp", null, [".r1y684pp{display:inline-flex;align-items:center;box-sizing:border-box;width:fit-content;}"]);
const useRootStyles = /*#__PURE__*/__styles({
  rounded: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5"
  },
  circular: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f44lkw9"
  },
  medium: {
    Bqenvij: "f1d2rq10"
  },
  small: {
    Bqenvij: "frvgh55"
  },
  "extra-small": {
    Bqenvij: "fjamq6b"
  }
}, {
  d: [[".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f44lkw9{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], ".f1d2rq10{height:32px;}", ".frvgh55{height:24px;}", ".fjamq6b{height:20px;}"]
});
/**
 * Apply styling to the InteractionTag slots based on the state
 */
export const useInteractionTagStyles_unstable = state => {
  'use no memo';

  const rootBaseClassName = useRootBaseClassName();
  const rootStyles = useRootStyles();
  const {
    shape,
    size
  } = state;
  state.root.className = mergeClasses(interactionTagClassNames.root, rootBaseClassName, rootStyles[shape], rootStyles[size], state.root.className);
  return state;
};