'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagGroupClassNames: function() {
        return tagGroupClassNames;
    },
    useTagGroupStyles_unstable: function() {
        return useTagGroupStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tagGroupClassNames = {
    root: 'fui-TagGroup'
};
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeStyles)({
    base: {
        display: 'inline-flex'
    },
    medium: {
        columnGap: _reacttheme.tokens.spacingHorizontalS
    },
    small: {
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge
    },
    'extra-small': {
        columnGap: _reacttheme.tokens.spacingHorizontalXS
    }
});
const useTagGroupStyles_unstable = (state)=>{
    'use no memo';
    const styles = useRootStyles();
    const { size } = state;
    state.root.className = (0, _react.mergeClasses)(tagGroupClassNames.root, styles.base, styles[size], state.root.className);
    return state;
};
