'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTagGroup_unstable", {
    enumerable: true,
    get: function() {
        return useTagGroup_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useInteractionTagSecondaryStylesstyles = require("../InteractionTagSecondary/useInteractionTagSecondaryStyles.styles");
const useTagGroup_unstable = (props, ref)=>{
    const { onDismiss, disabled = false, defaultSelectedValues, size = 'medium', appearance = 'filled', dismissible = false, role = 'toolbar', onTagSelect, selectedValues, ...rest } = props;
    const innerRef = _react.useRef(undefined);
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const { findNextFocusable, findPrevFocusable } = (0, _reacttabster.useFocusFinders)();
    const [items, setItems] = (0, _reactutilities.useControllableState)({
        defaultState: defaultSelectedValues,
        state: selectedValues,
        initialState: []
    });
    const handleTagDismiss = (0, _reactutilities.useEventCallback)((e, data)=>{
        var _innerRef_current;
        onDismiss === null || onDismiss === void 0 ? void 0 : onDismiss(e, data);
        // set focus after tag dismiss
        const activeElement = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.activeElement;
        if ((_innerRef_current = innerRef.current) === null || _innerRef_current === void 0 ? void 0 : _innerRef_current.contains(activeElement)) {
            // focus on next tag only if the active element is within the current tag group
            const next = findNextFocusable(activeElement, {
                container: innerRef.current
            });
            if (next) {
                next.focus();
                return;
            }
            // if there is no next focusable, focus on the previous focusable
            if (activeElement === null || activeElement === void 0 ? void 0 : activeElement.className.includes(_useInteractionTagSecondaryStylesstyles.interactionTagSecondaryClassNames.root)) {
                const prev = findPrevFocusable(activeElement.parentElement, {
                    container: innerRef.current
                });
                prev === null || prev === void 0 ? void 0 : prev.focus();
            } else {
                const prev = findPrevFocusable(activeElement, {
                    container: innerRef.current
                });
                prev === null || prev === void 0 ? void 0 : prev.focus();
            }
        }
    });
    const handleTagSelect = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onTagSelect, (_, data)=>{
        if (items.includes(data.value)) {
            setItems(items.filter((item)=>item !== data.value));
        } else {
            setItems([
                ...items,
                data.value
            ]);
        }
    }));
    const arrowNavigationProps = (0, _reacttabster.useArrowNavigationGroup)({
        circular: true,
        axis: 'both',
        memorizeCurrent: true
    });
    return {
        handleTagDismiss,
        handleTagSelect: onTagSelect ? handleTagSelect : undefined,
        selectedValues: items,
        role,
        size,
        disabled,
        appearance,
        dismissible,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, innerRef),
            role,
            'aria-disabled': disabled,
            ...arrowNavigationProps,
            ...rest
        }), {
            elementType: 'div'
        })
    };
};
