'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagClassNames: function() {
        return tagClassNames;
    },
    useIconStyles: function() {
        return useIconStyles;
    },
    useMediaStyles: function() {
        return useMediaStyles;
    },
    usePrimaryTextStyles: function() {
        return usePrimaryTextStyles;
    },
    useSecondaryTextBaseClassName: function() {
        return useSecondaryTextBaseClassName;
    },
    useTagStyles_unstable: function() {
        return useTagStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const tagClassNames = {
    root: 'fui-Tag',
    media: 'fui-Tag__media',
    icon: 'fui-Tag__icon',
    primaryText: 'fui-Tag__primaryText',
    secondaryText: 'fui-Tag__secondaryText',
    dismissIcon: 'fui-Tag__dismissIcon'
};
/**
 * Inner horizontal space left and right of Tag
 */ const tagSpacingMedium = '7px';
const tagSpacingSmall = '5px';
const tagSpacingExtraSmall = '5px';
const mediumIconSize = '20px';
const smallIconSize = '16px';
const extraSmallIconSize = '12px';
const baseStyles = {
    // reset default button style:
    fontFamily: 'inherit',
    padding: '0px',
    appearance: 'button',
    textAlign: 'unset',
    display: 'inline-grid',
    alignItems: 'center',
    gridTemplateAreas: `
  "media primary   dismissIcon"
  "media secondary dismissIcon"
  `,
    boxSizing: 'border-box',
    width: 'fit-content',
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`
};
const useRootRoundedBaseClassName = (0, _react.makeResetStyles)({
    ...baseStyles,
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`
    }),
    /**
   * Pseudo element to draw the border for windows high contrast mode -
   * when Tag is with secondary text, primary text has negative margin that covers the border.
   */ '@media (forced-colors: active)': {
        position: 'relative',
        '::before': {
            content: '""',
            borderTop: `${_reacttheme.tokens.strokeWidthThin} solid`,
            position: 'absolute',
            inset: '-1px',
            borderTopLeftRadius: _reacttheme.tokens.borderRadiusMedium,
            borderTopRightRadius: _reacttheme.tokens.borderRadiusMedium
        }
    }
});
const useRootCircularBaseClassName = (0, _react.makeResetStyles)({
    ...baseStyles,
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`
    }),
    /**
   * Pseudo element to draw the border for windows high contrast mode -
   * when Tag is with secondary text, primary text has negative margin that covers the border.
   */ '@media (forced-colors: active)': {
        position: 'relative',
        '::before': {
            content: '""',
            borderTop: `${_reacttheme.tokens.strokeWidthThin} solid`,
            borderLeft: `${_reacttheme.tokens.strokeWidthThin} solid`,
            borderRight: `${_reacttheme.tokens.strokeWidthThin} solid`,
            position: 'absolute',
            inset: '-1px',
            borderRadius: _reacttheme.tokens.borderRadiusCircular
        }
    }
});
const useRootStyles = (0, _react.makeStyles)({
    filled: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        color: _reacttheme.tokens.colorNeutralForeground2
    },
    outline: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForeground2,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1)
    },
    brand: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground2,
        color: _reacttheme.tokens.colorBrandForeground2
    },
    selected: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorBrandStroke1),
        '@media (forced-colors: active)': {
            forcedColorAdjust: 'none',
            backgroundColor: 'Highlight',
            color: 'HighlightText'
        }
    },
    medium: {
        height: '32px'
    },
    small: {
        height: '24px'
    },
    'extra-small': {
        position: 'relative',
        height: '20px',
        // Increase clickable area to meet WCAG 2.2 AA
        // https://www.w3.org/WAI/WCAG22/Understanding/target-size-minimum.html
        '@media (forced-colors: none)': {
            '&:before, &:after': {
                content: '""',
                position: 'absolute',
                height: '2px',
                left: '0',
                width: '100%'
            },
            '&:before': {
                bottom: '100%'
            },
            '&:after': {
                top: '100%'
            }
        }
    }
});
const useRootDisabledStyles = (0, _react.makeStyles)({
    filled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled)
    },
    outline: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled)
    },
    brand: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled)
    }
});
/**
 * Styles for root slot when Tag is without leading media/icon
 */ const useRootWithoutMediaStyles = (0, _react.makeStyles)({
    medium: {
        paddingLeft: tagSpacingMedium
    },
    small: {
        paddingLeft: tagSpacingSmall
    },
    'extra-small': {
        paddingLeft: tagSpacingExtraSmall
    }
});
/**
 * Styles for root slot when Tag is without dismiss icon
 */ const useRootWithoutDismissStyles = (0, _react.makeStyles)({
    medium: {
        paddingRight: tagSpacingMedium
    },
    small: {
        paddingRight: tagSpacingSmall
    },
    'extra-small': {
        paddingRight: tagSpacingExtraSmall
    }
});
const useIconStyles = (0, _react.makeStyles)({
    base: {
        gridArea: 'media',
        display: 'flex',
        boxSizing: 'content-box'
    },
    medium: {
        paddingLeft: tagSpacingMedium,
        paddingRight: _reacttheme.tokens.spacingHorizontalXS,
        width: mediumIconSize,
        fontSize: mediumIconSize
    },
    small: {
        paddingLeft: tagSpacingSmall,
        paddingRight: _reacttheme.tokens.spacingHorizontalXXS,
        width: smallIconSize,
        fontSize: smallIconSize
    },
    'extra-small': {
        paddingLeft: tagSpacingExtraSmall,
        paddingRight: _reacttheme.tokens.spacingHorizontalXXS,
        width: extraSmallIconSize,
        fontSize: extraSmallIconSize
    }
});
const useMediaStyles = (0, _react.makeStyles)({
    base: {
        gridArea: 'media',
        display: 'flex',
        paddingLeft: '1px'
    },
    medium: {
        paddingRight: _reacttheme.tokens.spacingHorizontalS
    },
    small: {
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    },
    'extra-small': {
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    }
});
const useDismissIconStyles = (0, _react.makeStyles)({
    base: {
        gridArea: 'dismissIcon',
        display: 'flex',
        // windows high contrast:
        '@media (forced-colors: active)': {
            ':hover': {
                color: 'Highlight'
            },
            ':active': {
                color: 'Highlight'
            }
        }
    },
    medium: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXS,
        paddingRight: tagSpacingMedium,
        fontSize: mediumIconSize
    },
    small: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXXS,
        paddingRight: tagSpacingSmall,
        fontSize: smallIconSize
    },
    'extra-small': {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXXS,
        paddingRight: tagSpacingExtraSmall,
        fontSize: extraSmallIconSize
    },
    filled: {
        ':hover': {
            cursor: 'pointer',
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        ':active': {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        }
    },
    outline: {
        ':hover': {
            cursor: 'pointer',
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        ':active': {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        }
    },
    brand: {
        ':hover': {
            cursor: 'pointer',
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        ':active': {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        }
    },
    selected: {
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        ':active': {
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        }
    }
});
const usePrimaryTextStyles = (0, _react.makeStyles)({
    base: {
        whiteSpace: 'nowrap',
        paddingLeft: _reacttheme.tokens.spacingHorizontalXXS,
        paddingRight: _reacttheme.tokens.spacingHorizontalXXS
    },
    medium: {
        ..._reacttheme.typographyStyles.body1
    },
    small: {
        ..._reacttheme.typographyStyles.caption1
    },
    'extra-small': {
        ..._reacttheme.typographyStyles.caption1
    },
    withoutSecondaryText: {
        gridColumnStart: 'primary',
        gridRowStart: 'primary',
        gridRowEnd: 'secondary',
        paddingBottom: _reacttheme.tokens.spacingHorizontalXXS
    },
    withSecondaryText: {
        gridArea: 'primary',
        ..._reacttheme.typographyStyles.caption1,
        marginTop: '-2px'
    }
});
const useSecondaryTextBaseClassName = (0, _react.makeResetStyles)({
    gridArea: 'secondary',
    paddingLeft: _reacttheme.tokens.spacingHorizontalXXS,
    paddingRight: _reacttheme.tokens.spacingHorizontalXXS,
    ..._reacttheme.typographyStyles.caption2,
    whiteSpace: 'nowrap'
});
const useTagStyles_unstable = (state)=>{
    'use no memo';
    const rootRoundedBaseClassName = useRootRoundedBaseClassName();
    const rootCircularBaseClassName = useRootCircularBaseClassName();
    const rootStyles = useRootStyles();
    const rootDisabledStyles = useRootDisabledStyles();
    const rootWithoutMediaStyles = useRootWithoutMediaStyles();
    const rootWithoutDismissStyles = useRootWithoutDismissStyles();
    const iconStyles = useIconStyles();
    const mediaStyles = useMediaStyles();
    const dismissIconStyles = useDismissIconStyles();
    const primaryTextStyles = usePrimaryTextStyles();
    const secondaryTextBaseClassName = useSecondaryTextBaseClassName();
    const { disabled, shape, size, appearance, selected } = state;
    state.root.className = (0, _react.mergeClasses)(tagClassNames.root, shape === 'rounded' ? rootRoundedBaseClassName : rootCircularBaseClassName, disabled ? rootDisabledStyles[appearance] : rootStyles[appearance], selected && !disabled && rootStyles.selected, rootStyles[size], !state.media && !state.icon && rootWithoutMediaStyles[size], !state.dismissIcon && rootWithoutDismissStyles[size], state.root.className);
    if (state.media) {
        state.media.className = (0, _react.mergeClasses)(tagClassNames.media, mediaStyles.base, mediaStyles[size], state.media.className);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(tagClassNames.icon, iconStyles.base, iconStyles[size], state.icon.className);
    }
    if (state.primaryText) {
        state.primaryText.className = (0, _react.mergeClasses)(tagClassNames.primaryText, primaryTextStyles.base, primaryTextStyles[size], state.secondaryText ? primaryTextStyles.withSecondaryText : primaryTextStyles.withoutSecondaryText, state.primaryText.className);
    }
    if (state.secondaryText) {
        state.secondaryText.className = (0, _react.mergeClasses)(tagClassNames.secondaryText, secondaryTextBaseClassName, state.secondaryText.className);
    }
    if (state.dismissIcon) {
        state.dismissIcon.className = (0, _react.mergeClasses)(tagClassNames.dismissIcon, dismissIconStyles.base, dismissIconStyles[size], !disabled && dismissIconStyles[appearance], selected && !disabled && dismissIconStyles.selected, state.dismissIcon.className);
    }
    return state;
};
