'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    interactionTagSecondaryClassNames: function() {
        return interactionTagSecondaryClassNames;
    },
    useInteractionTagSecondaryStyles_unstable: function() {
        return useInteractionTagSecondaryStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const interactionTagSecondaryClassNames = {
    root: 'fui-InteractionTagSecondary'
};
const mediumIconSize = '20px';
const smallIconSize = '16px';
const extraSmallIconSize = '12px';
const useRootBaseClassName = (0, _react.makeResetStyles)({
    // reset default button style:
    color: 'inherit',
    fontFamily: 'inherit',
    padding: '0px',
    borderStyle: 'none',
    appearance: 'button',
    textAlign: 'unset',
    backgroundColor: 'transparent',
    display: 'flex',
    height: '100%',
    alignItems: 'center',
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`
    }),
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
    // divider:
    borderLeftColor: _reacttheme.tokens.colorNeutralStroke1,
    borderTopLeftRadius: _reacttheme.tokens.borderRadiusNone,
    borderBottomLeftRadius: _reacttheme.tokens.borderRadiusNone
});
const useRootStyles = (0, _react.makeStyles)({
    filled: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        color: _reacttheme.tokens.colorNeutralForeground2,
        borderTopWidth: 0,
        borderBottomWidth: 0,
        ':hover': {
            cursor: 'pointer',
            backgroundColor: _reacttheme.tokens.colorNeutralBackground3Hover,
            color: _reacttheme.tokens.colorNeutralForeground2BrandHover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground3Pressed,
            color: _reacttheme.tokens.colorNeutralForeground2BrandPressed
        },
        '@media (forced-colors: active)': {
            borderTopWidth: `${_reacttheme.tokens.strokeWidthThin}`,
            borderBottomWidth: `${_reacttheme.tokens.strokeWidthThin}`,
            ':hover': {
                backgroundColor: 'HighlightText'
            },
            ':active': {
                backgroundColor: 'HighlightText'
            }
        }
    },
    outline: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForeground2,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1),
        ':hover': {
            cursor: 'pointer',
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
            color: _reacttheme.tokens.colorNeutralForeground2BrandHover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
            color: _reacttheme.tokens.colorNeutralForeground2BrandPressed
        },
        '@media (forced-colors: active)': {
            ':hover': {
                backgroundColor: 'HighlightText'
            },
            ':active': {
                backgroundColor: 'HighlightText'
            }
        }
    },
    brand: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground2,
        color: _reacttheme.tokens.colorBrandForeground2,
        borderLeftColor: _reacttheme.tokens.colorBrandStroke2,
        borderTopWidth: 0,
        borderBottomWidth: 0,
        ':hover': {
            cursor: 'pointer',
            backgroundColor: _reacttheme.tokens.colorBrandBackground2Hover,
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackground2Pressed,
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        },
        '@media (forced-colors: active)': {
            borderTopWidth: `${_reacttheme.tokens.strokeWidthThin}`,
            borderBottomWidth: `${_reacttheme.tokens.strokeWidthThin}`,
            ':hover': {
                backgroundColor: 'HighlightText'
            },
            ':active': {
                backgroundColor: 'HighlightText'
            }
        }
    },
    selected: {
        background: _reacttheme.tokens.colorBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorBrandStroke1),
        '@media (forced-colors: active)': {
            forcedColorAdjust: 'none',
            backgroundColor: 'Highlight',
            color: 'HighlightText'
        },
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundHover,
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
            '@media (forced-colors: active)': {
                backgroundColor: 'Highlight',
                color: 'HighlightText'
            }
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundPressed,
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
            '@media (forced-colors: active)': {
                backgroundColor: 'Highlight',
                color: 'HighlightText'
            }
        },
        // divider
        borderLeftColor: _reacttheme.tokens.colorNeutralStrokeOnBrand2
    },
    rounded: {
        borderTopRightRadius: _reacttheme.tokens.borderRadiusMedium,
        borderBottomRightRadius: _reacttheme.tokens.borderRadiusMedium
    },
    circular: {
        borderTopRightRadius: _reacttheme.tokens.borderRadiusCircular,
        borderBottomRightRadius: _reacttheme.tokens.borderRadiusCircular
    },
    medium: {
        fontSize: mediumIconSize,
        paddingLeft: '5px',
        paddingRight: '5px'
    },
    small: {
        fontSize: smallIconSize,
        paddingLeft: '3px',
        paddingRight: '3px'
    },
    'extra-small': {
        fontSize: extraSmallIconSize,
        paddingLeft: '5px',
        paddingRight: '5px',
        position: 'relative',
        '@media (forced-colors: none)': {
            '&:before, &:after': {
                content: '""',
                position: 'absolute',
                height: '2px',
                left: '0',
                width: '100%'
            },
            '&:before': {
                bottom: '100%'
            },
            '&:after': {
                top: '100%'
            }
        }
    }
});
const useRootDisabledStyles = (0, _react.makeStyles)({
    filled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled),
        borderLeftColor: _reacttheme.tokens.colorNeutralStrokeDisabled
    },
    outline: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled)
    },
    brand: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled),
        borderLeftColor: _reacttheme.tokens.colorNeutralStrokeDisabled
    }
});
const useInteractionTagSecondaryStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    const rootDisabledStyles = useRootDisabledStyles();
    const { disabled, selected, shape, size, appearance } = state;
    state.root.className = (0, _react.mergeClasses)(interactionTagSecondaryClassNames.root, rootBaseClassName, disabled ? rootDisabledStyles[appearance] : rootStyles[appearance], rootStyles[shape], rootStyles[size], selected && !disabled && rootStyles.selected, state.root.className);
    return state;
};
