'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInteractionTagSecondary_unstable", {
    enumerable: true,
    get: function() {
        return useInteractionTagSecondary_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reacticons = require("@fluentui/react-icons");
const _interactionTagContext = require("../../contexts/interactionTagContext");
const useInteractionTagSecondary_unstable = (props, ref)=>{
    const { appearance, disabled, handleTagDismiss, interactionTagPrimaryId, selected, shape, size, value } = (0, _interactionTagContext.useInteractionTagContext_unstable)();
    const id = (0, _reactutilities.useId)('fui-InteractionTagSecondary-', props.id);
    const onClick = (0, _reactutilities.useEventCallback)((ev)=>{
        var _props_onClick;
        props === null || props === void 0 ? void 0 : (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, ev);
        if (!ev.defaultPrevented) {
            handleTagDismiss === null || handleTagDismiss === void 0 ? void 0 : handleTagDismiss(ev, {
                value
            });
        }
    });
    const onKeyDown = (0, _reactutilities.useEventCallback)((ev)=>{
        var _props_onKeyDown;
        props === null || props === void 0 ? void 0 : (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, ev);
        if (!ev.defaultPrevented && (ev.key === _keyboardkeys.Delete || ev.key === _keyboardkeys.Backspace)) {
            handleTagDismiss === null || handleTagDismiss === void 0 ? void 0 : handleTagDismiss(ev, {
                value
            });
        }
    });
    return {
        appearance,
        disabled,
        selected,
        shape,
        size,
        components: {
            root: 'button'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            children: /*#__PURE__*/ _react.createElement(_reacticons.DismissRegular, null),
            type: 'button',
            disabled,
            ref,
            'aria-labelledby': `${interactionTagPrimaryId} ${id}`,
            ...props,
            id,
            onClick,
            onKeyDown
        }), {
            elementType: 'button'
        })
    };
};
