'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    interactionTagPrimaryClassNames: function() {
        return interactionTagPrimaryClassNames;
    },
    useInteractionTagPrimaryStyles_unstable: function() {
        return useInteractionTagPrimaryStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _reacticons = require("@fluentui/react-icons");
const _useTagStylesstyles = require("../Tag/useTagStyles.styles");
const interactionTagPrimaryClassNames = {
    root: 'fui-InteractionTagPrimary',
    media: 'fui-InteractionTagPrimary__media',
    icon: 'fui-InteractionTagPrimary__icon',
    primaryText: 'fui-InteractionTagPrimary__primaryText',
    secondaryText: 'fui-InteractionTagPrimary__secondaryText'
};
const baseStyles = {
    // reset default button style:
    color: 'inherit',
    fontFamily: 'inherit',
    padding: '0px',
    borderStyle: 'none',
    appearance: 'button',
    textAlign: 'unset',
    backgroundColor: 'transparent',
    display: 'inline-grid',
    height: '100%',
    alignItems: 'center',
    gridTemplateAreas: `
  "media primary  "
  "media secondary"
  `,
    border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
        zIndex: 1
    })
};
const useRootRoundedBaseClassName = (0, _react.makeResetStyles)({
    ...baseStyles,
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    /**
   * Pseudo element to draw the border for windows high contrast mode -
   * when Tag is with secondary text, primary text has negative margin that covers the border.
   */ '@media (forced-colors: active)': {
        position: 'relative',
        '::before': {
            content: '""',
            borderTop: `${_reacttheme.tokens.strokeWidthThin} solid`,
            position: 'absolute',
            inset: '-1px',
            borderTopLeftRadius: _reacttheme.tokens.borderRadiusMedium,
            borderTopRightRadius: _reacttheme.tokens.borderRadiusMedium
        }
    }
});
const useRootCircularBaseClassName = (0, _react.makeResetStyles)({
    ...baseStyles,
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    /**
   * Pseudo element to draw the border for windows high contrast mode -
   * when Tag is with secondary text, primary text has negative margin that covers the border.
   */ '@media (forced-colors: active)': {
        position: 'relative',
        '::before': {
            content: '""',
            borderTop: `${_reacttheme.tokens.strokeWidthThin} solid`,
            borderLeft: `${_reacttheme.tokens.strokeWidthThin} solid`,
            position: 'absolute',
            inset: '-1px',
            borderTopLeftRadius: _reacttheme.tokens.borderRadiusCircular,
            borderBottomLeftRadius: _reacttheme.tokens.borderRadiusCircular
        }
    }
});
/**
 * Style override for pseudo element that draws the border for windows high contrast mode
 */ const useRootCircularContrastStyles = (0, _react.makeStyles)({
    withoutSecondaryAction: {
        '@media (forced-colors: active)': {
            position: 'relative',
            '::before': {
                borderRight: `${_reacttheme.tokens.strokeWidthThin} solid transparent`,
                borderTopRightRadius: _reacttheme.tokens.borderRadiusCircular,
                borderBottomRightRadius: _reacttheme.tokens.borderRadiusCircular
            }
        }
    }
});
const useRootStyles = (0, _react.makeStyles)({
    filled: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        color: _reacttheme.tokens.colorNeutralForeground2,
        ':hover': {
            cursor: 'pointer',
            backgroundColor: _reacttheme.tokens.colorNeutralBackground3Hover,
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground3Pressed,
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        },
        '@media (forced-colors: active)': {
            ':hover': {
                backgroundColor: 'HighlightText'
            },
            ':active': {
                backgroundColor: 'HighlightText'
            }
        }
    },
    outline: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForeground2,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1),
        ':hover': {
            cursor: 'pointer',
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
            color: _reacttheme.tokens.colorNeutralForeground2Hover,
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'inline',
                color: _reacttheme.tokens.colorNeutralForeground2BrandHover
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'none'
            }
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
            color: _reacttheme.tokens.colorNeutralForeground2Pressed,
            [`& .${_reacticons.iconFilledClassName}`]: {
                display: 'inline',
                color: _reacttheme.tokens.colorNeutralForeground2BrandPressed
            },
            [`& .${_reacticons.iconRegularClassName}`]: {
                display: 'none'
            }
        },
        '@media (forced-colors: active)': {
            ':hover': {
                backgroundColor: 'HighlightText'
            },
            ':active': {
                backgroundColor: 'HighlightText'
            }
        }
    },
    brand: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground2,
        color: _reacttheme.tokens.colorBrandForeground2,
        ':hover': {
            cursor: 'pointer',
            backgroundColor: _reacttheme.tokens.colorBrandBackground2Hover,
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackground2Pressed,
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        },
        '@media (forced-colors: active)': {
            ':hover': {
                backgroundColor: 'HighlightText'
            },
            ':active': {
                backgroundColor: 'HighlightText'
            }
        }
    },
    selected: {
        background: _reacttheme.tokens.colorBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorBrandStroke1),
        '@media (forced-colors: active)': {
            forcedColorAdjust: 'none',
            backgroundColor: 'Highlight',
            color: 'HighlightText'
        },
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundHover,
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
            [`& .${_reacticons.iconFilledClassName}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundOnBrand
            },
            '@media (forced-colors: active)': {
                backgroundColor: 'Highlight',
                color: 'HighlightText'
            }
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundPressed,
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
            [`& .${_reacticons.iconFilledClassName}`]: {
                color: _reacttheme.tokens.colorNeutralForegroundOnBrand
            },
            '@media (forced-colors: active)': {
                backgroundColor: 'Highlight',
                color: 'HighlightText'
            }
        }
    },
    medium: {
        paddingRight: '7px'
    },
    small: {
        paddingRight: '5px'
    },
    'extra-small': {
        paddingRight: '5px',
        position: 'relative',
        // Increase clickable area to meet WCAG 2.2 AA
        // https://www.w3.org/WAI/WCAG22/Understanding/target-size-minimum.html
        '@media (forced-colors: none)': {
            '&:before, &:after': {
                content: '""',
                position: 'absolute',
                height: '2px',
                left: '0',
                width: '100%'
            },
            '&:before': {
                bottom: '100%'
            },
            '&:after': {
                top: '100%'
            }
        }
    }
});
const useRootDisabledAppearances = (0, _react.makeStyles)({
    filled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled)
    },
    outline: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled)
    },
    brand: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled)
    }
});
/**
 * Styles for InteractionTagPrimary without leading media/icon
 */ const useRootWithoutMediaStyles = (0, _react.makeStyles)({
    medium: {
        paddingLeft: '7px'
    },
    small: {
        paddingLeft: '5px'
    },
    'extra-small': {
        paddingLeft: '5px'
    }
});
/**
 * Styles for InteractionTagPrimary when InteractionTag has a Secondary button
 */ const useRootWithSecondaryActionStyles = (0, _react.makeStyles)({
    base: {
        borderTopRightRadius: _reacttheme.tokens.borderRadiusNone,
        borderBottomRightRadius: _reacttheme.tokens.borderRadiusNone,
        borderRightStyle: 'none',
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderTopRightRadius: _reacttheme.tokens.borderRadiusNone,
            borderBottomRightRadius: _reacttheme.tokens.borderRadiusNone
        }),
        '@media (forced-colors: active)': {
            '::before': {
                borderTopRightRadius: '0'
            }
        }
    },
    medium: {
        paddingRight: _reacttheme.tokens.spacingHorizontalS
    },
    small: {
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    },
    'extra-small': {
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    }
});
const useInteractionTagPrimaryStyles_unstable = (state)=>{
    'use no memo';
    const rootRoundedBaseClassName = useRootRoundedBaseClassName();
    const rootCircularBaseClassName = useRootCircularBaseClassName();
    const rootStyles = useRootStyles();
    const rootDisabledAppearances = useRootDisabledAppearances();
    const rootWithoutMediaStyles = useRootWithoutMediaStyles();
    const rootWithSecondaryActionStyles = useRootWithSecondaryActionStyles();
    const iconStyles = (0, _useTagStylesstyles.useIconStyles)();
    const mediaStyles = (0, _useTagStylesstyles.useMediaStyles)();
    const primaryTextStyles = (0, _useTagStylesstyles.usePrimaryTextStyles)();
    const secondaryTextBaseClassName = (0, _useTagStylesstyles.useSecondaryTextBaseClassName)();
    const rootCircularContrastStyles = useRootCircularContrastStyles();
    const { disabled, shape, size, appearance, selected } = state;
    state.root.className = (0, _react.mergeClasses)(interactionTagPrimaryClassNames.root, shape === 'rounded' ? rootRoundedBaseClassName : rootCircularBaseClassName, shape === 'circular' && !state.hasSecondaryAction && rootCircularContrastStyles.withoutSecondaryAction, disabled ? rootDisabledAppearances[appearance] : rootStyles[appearance], selected && !disabled && rootStyles.selected, rootStyles[size], !state.media && !state.icon && rootWithoutMediaStyles[size], state.hasSecondaryAction && rootWithSecondaryActionStyles.base, state.hasSecondaryAction && rootWithSecondaryActionStyles[size], state.root.className);
    if (state.media) {
        state.media.className = (0, _react.mergeClasses)(interactionTagPrimaryClassNames.media, mediaStyles.base, mediaStyles[size], state.media.className);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(interactionTagPrimaryClassNames.icon, iconStyles.base, iconStyles[size], state.icon.className);
    }
    if (state.primaryText) {
        state.primaryText.className = (0, _react.mergeClasses)(interactionTagPrimaryClassNames.primaryText, primaryTextStyles.base, primaryTextStyles[size], state.secondaryText ? primaryTextStyles.withSecondaryText : primaryTextStyles.withoutSecondaryText, state.primaryText.className);
    }
    if (state.secondaryText) {
        state.secondaryText.className = (0, _react.mergeClasses)(interactionTagPrimaryClassNames.secondaryText, secondaryTextBaseClassName, state.secondaryText.className);
    }
    return state;
};
