'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInteractionTagPrimary_unstable", {
    enumerable: true,
    get: function() {
        return useInteractionTagPrimary_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _interactionTagContext = require("../../contexts/interactionTagContext");
const avatarSizeMap = {
    medium: 28,
    small: 20,
    'extra-small': 16
};
const avatarShapeMap = {
    rounded: 'square',
    circular: 'circular'
};
const useInteractionTagPrimary_unstable = (props, ref)=>{
    const { appearance, disabled, handleTagSelect, interactionTagPrimaryId, selected: contextSelected, selectedValues, shape, size, value } = (0, _interactionTagContext.useInteractionTagContext_unstable)();
    const { hasSecondaryAction = false } = props;
    const onClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(props === null || props === void 0 ? void 0 : props.onClick, (event)=>handleTagSelect === null || handleTagSelect === void 0 ? void 0 : handleTagSelect(event, {
            type: 'click',
            event,
            value,
            selectedValues
        })));
    return {
        appearance,
        avatarShape: avatarShapeMap[shape],
        avatarSize: avatarSizeMap[size],
        disabled,
        hasSecondaryAction,
        selected: contextSelected,
        shape,
        size,
        components: {
            root: 'button',
            media: 'span',
            icon: 'span',
            primaryText: 'span',
            secondaryText: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            ref,
            disabled,
            id: interactionTagPrimaryId,
            ...handleTagSelect !== undefined && {
                'aria-pressed': contextSelected
            },
            onClick,
            ...props
        }), {
            elementType: 'button'
        }),
        media: _reactutilities.slot.optional(props.media, {
            elementType: 'span'
        }),
        icon: _reactutilities.slot.optional(props.icon, {
            elementType: 'span'
        }),
        primaryText: _reactutilities.slot.optional(props.primaryText, {
            renderByDefault: true,
            defaultProps: {
                children: props.children
            },
            elementType: 'span'
        }),
        secondaryText: _reactutilities.slot.optional(props.secondaryText, {
            elementType: 'span'
        })
    };
};
