'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    interactionTagClassNames: function() {
        return interactionTagClassNames;
    },
    useInteractionTagStyles_unstable: function() {
        return useInteractionTagStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const interactionTagClassNames = {
    root: 'fui-InteractionTag'
};
const useRootBaseClassName = (0, _react.makeResetStyles)({
    display: 'inline-flex',
    alignItems: 'center',
    boxSizing: 'border-box',
    width: 'fit-content'
});
const useRootStyles = (0, _react.makeStyles)({
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    },
    circular: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular
    },
    medium: {
        height: '32px'
    },
    small: {
        height: '24px'
    },
    'extra-small': {
        height: '20px'
    }
});
const useInteractionTagStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    const { shape, size } = state;
    state.root.className = (0, _react.mergeClasses)(interactionTagClassNames.root, rootBaseClassName, rootStyles[shape], rootStyles[size], state.root.className);
    return state;
};
