'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInteractionTag_unstable", {
    enumerable: true,
    get: function() {
        return useInteractionTag_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _tagGroupContext = require("../../contexts/tagGroupContext");
const useInteractionTag_unstable = (props, ref)=>{
    const { handleTagDismiss, handleTagSelect, size: contextSize, disabled: contextDisabled, appearance: contextAppearance, selectedValues = [] } = (0, _tagGroupContext.useTagGroupContext_unstable)();
    const id = (0, _reactutilities.useId)('fui-InteractionTag-', props.id);
    const interactionTagPrimaryId = (0, _reactutilities.useId)('fui-InteractionTagPrimary-');
    const { appearance = contextAppearance !== null && contextAppearance !== void 0 ? contextAppearance : 'filled', disabled = false, selected = false, shape = 'rounded', size = contextSize, value = id } = props;
    return {
        appearance,
        disabled: contextDisabled ? true : disabled,
        handleTagDismiss,
        handleTagSelect,
        interactionTagPrimaryId,
        selected: selectedValues.includes(value) || selected,
        selectedValues,
        shape,
        size,
        value,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            ...props,
            disabled: contextDisabled ? true : disabled,
            id
        }), {
            elementType: 'div'
        })
    };
};
