import { AvatarShape } from '@fluentui/react-avatar';
import { AvatarSize } from '@fluentui/react-avatar';
import { ComponentProps } from '@fluentui/react-utilities';
import { ComponentState } from '@fluentui/react-utilities';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * InteractionTag component - a visual representation of an attribute with primary and secondary actions.
 * Can have `InteractionTagPrimary` and `InteractionTagSecondary` components as its children.
 */
export declare const InteractionTag: ForwardRefComponent<InteractionTagProps>;

export declare const interactionTagClassNames: SlotClassNames<InteractionTagSlots>;

/**
 * Context shared between InteractionTag and its children components
 */
declare type InteractionTagContextValue<Value = string> = Required<Pick<InteractionTagState, 'appearance' | 'disabled' | 'selected' | 'selectedValues' | 'shape' | 'size'> & {
    handleTagDismiss: TagDismissHandler<Value>;
    interactionTagPrimaryId: string;
    value?: Value;
}> & {
    handleTagSelect?: TagSelectHandler<Value>;
};

declare type InteractionTagContextValues = {
    interactionTag: InteractionTagContextValue;
};

/**
 * InteractionTagPrimary component - used as the first child of the `InteractionTag` component.
 * Provides visual attributes such as media, icon, primary and secondary text, as well as the ability to attach a primary action.
 */
export declare const InteractionTagPrimary: ForwardRefComponent<InteractionTagPrimaryProps>;

export declare const interactionTagPrimaryClassNames: SlotClassNames<InteractionTagPrimarySlots>;

export declare type InteractionTagPrimaryContextValues = TagAvatarContextValues;

/**
 * InteractionTagPrimary Props
 */
export declare type InteractionTagPrimaryProps = ComponentProps<Partial<InteractionTagPrimarySlots>> & {
    /**
     * Whether the `InteractionTag` component has a `Secondary` component that provides an secondary action.
     * If `true`, the `InteractionTagPrimary` component will adjust its styles to accommodate the `Secondary` component.
     *
     * @default false
     */
    hasSecondaryAction?: boolean;
};

export declare type InteractionTagPrimarySlots = {
    root: NonNullable<Slot<'button'>>;
    /**
     * Slot for a visual element, usually an avatar
     */
    media?: Slot<'span'>;
    /**
     * Slot for an icon
     */
    icon?: Slot<'span'>;
    /**
     * Main text for the InteractionTagPrimary button. Children of the root slot are automatically rendered here
     */
    primaryText: Slot<'span'>;
    /**
     * Secondary text that describes or complements the main text
     */
    secondaryText?: Slot<'span'>;
};

/**
 * State used in rendering InteractionTagPrimary
 */
export declare type InteractionTagPrimaryState = ComponentState<InteractionTagPrimarySlots> & Required<Pick<InteractionTagContextValue, 'appearance' | 'disabled' | 'selected' | 'shape' | 'size'> & Pick<InteractionTagPrimaryProps, 'hasSecondaryAction'>> & UseTagAvatarContextValuesOptions;

/**
 * InteractionTag Props
 */
export declare type InteractionTagProps<Value = TagValue> = ComponentProps<Partial<InteractionTagSlots>> & {
    /**
     * An InteractionTag can have filled, outlined or brand experience.
     *
     * @default 'filled'
     */
    appearance?: TagAppearance;
    /**
     * An InteractionTag can show that it cannot be interacted with.
     *
     * @default false
     */
    disabled?: boolean;
    /**
     * An InteractionTag can be selected.
     * Note: This prop only changes the appearance of the tag at the moment. A future PR will add the integration with TagGroup.
     *
     * @default false
     */
    selected?: boolean;
    /**
     * An InteractionTag can have rounded or circular shape.
     *
     * @default 'round'
     */
    shape?: TagShape;
    /**
     * An InteractionTag has three sizes.
     *
     * @default 'medium'
     */
    size?: TagSize;
    /**
     * Unique value identifying the tag within a TagGroup
     */
    value?: Value;
};

/**
 * InteractionTagSecondary component - used as the second child of the `InteractionTag` component and provides the secondary action, which is dismiss by default.
 */
export declare const InteractionTagSecondary: ForwardRefComponent<InteractionTagSecondaryProps>;

export declare const interactionTagSecondaryClassNames: SlotClassNames<InteractionTagSecondarySlots>;

/**
 * InteractionTagSecondary Props
 */
export declare type InteractionTagSecondaryProps = ComponentProps<InteractionTagSecondarySlots>;

export declare type InteractionTagSecondarySlots = {
    root: NonNullable<Slot<'button'>>;
};

/**
 * State used in rendering InteractionTagSecondary
 */
export declare type InteractionTagSecondaryState = ComponentState<InteractionTagSecondarySlots> & Required<Pick<InteractionTagContextValue, 'appearance' | 'disabled' | 'selected' | 'shape' | 'size'>>;

export declare type InteractionTagSlots = {
    root: NonNullable<Slot<'div'>>;
};

/**
 * State used in rendering InteractionTag
 */
export declare type InteractionTagState<Value = TagValue> = ComponentState<InteractionTagSlots> & Required<Pick<InteractionTagProps, 'appearance' | 'disabled' | 'selected' | 'shape' | 'size' | 'value'>> & {
    /**
     * Event handler from TagGroup context that allows TagGroup to dismiss the tag
     */
    handleTagDismiss: TagDismissHandler<Value>;
    /**
     * Event handler from TagGroup context that allows TagGroup to select the tag
     */
    handleTagSelect?: TagSelectHandler<Value>;
    /**
     * Selected values from TagGroup context
     */
    selectedValues: Value[];
    /**
     * id to assign to InteractionTagPrimary
     */
    interactionTagPrimaryId: string;
};

/**
 * Render the final JSX of InteractionTag
 */
export declare const renderInteractionTag_unstable: (state: InteractionTagState, contextValues: InteractionTagContextValues) => JSXElement;

/**
 * Render the final JSX of InteractionTagPrimary
 */
export declare const renderInteractionTagPrimary_unstable: (state: InteractionTagPrimaryState, contextValues: InteractionTagPrimaryContextValues) => JSXElement;

/**
 * Render the final JSX of InteractionTagSecondary
 */
export declare const renderInteractionTagSecondary_unstable: (state: InteractionTagSecondaryState) => JSXElement;

/**
 * Render the final JSX of Tag
 */
export declare const renderTag_unstable: (state: TagState, contextValues: TagContextValues) => JSXElement;

/**
 * Render the final JSX of TagGroup
 */
export declare const renderTagGroup_unstable: (state: TagGroupState, contextValue: TagGroupContextValues) => JSXElement;

/**
 * Tag component -  a visual representation of an attribute.
 * Provides visual attributes such as media, icon, primary and secondary text, as well as the ability to attach an action (by default it is dismiss)
 */
export declare const Tag: ForwardRefComponent<TagProps>;

export declare type TagAppearance = 'filled' | 'outline' | 'brand';

declare type TagAvatarContextValues = {
    avatar: {
        size?: AvatarSize;
        shape?: AvatarShape;
    };
};

export declare const tagClassNames: SlotClassNames<TagSlots>;

declare type TagContextValues = TagAvatarContextValues;

export declare type TagDismissData<Value = TagValue> = {
    value: Value;
};

export declare type TagDismissEvent = React_2.MouseEvent | React_2.KeyboardEvent;

export declare type TagDismissHandler<Value = TagValue> = (e: TagDismissEvent, data: TagDismissData<Value>) => void;

/**
 * TagGroup component - a container for multiple tags.
 * Provides context to size or dismiss children tags.
 */
export declare const TagGroup: ForwardRefComponent<TagGroupProps>;

export declare const tagGroupClassNames: SlotClassNames<TagGroupSlots>;

/**
 * Context shared between TagGroup and its children components
 */
declare type TagGroupContextValue = Required<Pick<TagGroupState, 'handleTagDismiss' | 'size'>> & Partial<Pick<TagGroupState, 'disabled' | 'appearance' | 'dismissible' | 'handleTagSelect' | 'role' | 'selectedValues'>>;

export declare type TagGroupContextValues = {
    tagGroup: TagGroupContextValue;
};

/**
 * TagGroup Props
 */
export declare type TagGroupProps<Value = TagValue> = ComponentProps<TagGroupSlots> & {
    /**
     * Callback for when a tag is dismissed
     */
    onDismiss?: TagDismissHandler<Value>;
    /**
     * Sets selected values for an uncontrolled component.
     */
    defaultSelectedValues?: Value[];
    /**
     * A TagGroup can show that it cannot be interacted with.
     *
     * @default false
     */
    disabled?: boolean;
    size?: TagSize;
    appearance?: TagAppearance;
    dismissible?: boolean;
    /**
     * Callback for when a tag is selected
     */
    onTagSelect?: EventHandler<TagSelectData<Value>>;
    /**
     * Values of the selected tags
     */
    selectedValues?: Value[];
};

export declare type TagGroupSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering TagGroup
 */
export declare type TagGroupState<Value = TagValue> = ComponentState<TagGroupSlots> & Required<Pick<TagGroupProps, 'appearance' | 'dismissible' | 'disabled' | 'size' | 'selectedValues'>> & {
    handleTagDismiss: TagDismissHandler<Value>;
    handleTagSelect?: TagSelectHandler<Value>;
    role?: React_2.AriaRole;
};

/**
 * Tag Props
 */
export declare type TagProps<Value = string> = ComponentProps<Partial<TagSlots>> & {
    /**
     * A Tag can have filled, outlined or brand experience.
     *
     * @default 'filled'
     */
    appearance?: TagAppearance;
    /**
     * A Tag can show that it cannot be interacted with.
     *
     * @default false
     */
    disabled?: boolean;
    /**
     * A Tag can be dismissible
     *
     * @default false
     */
    dismissible?: boolean;
    /**
     * An InteractionTag can be selected.
     * Note: This prop only changes the appearance of the tag at the moment. A future PR will add the integration with TagGroup.
     *
     * @default false
     */
    selected?: boolean;
    /**
     * A Tag can have rounded or circular shape.
     *
     * @default 'round'
     */
    shape?: TagShape;
    /**
     * A Tag has three sizes.
     *
     * @default 'medium'
     */
    size?: TagSize;
    /**
     * Unique value identifying the tag within a TagGroup
     */
    value?: Value;
};

declare type TagSelectData<Value = TagValue> = EventData<'click', React_2.MouseEvent<HTMLButtonElement>> & {
    value: Value;
    selectedValues?: Value[];
};

declare type TagSelectHandler<Value = TagValue> = EventHandler<TagSelectData<Value>>;

export declare type TagShape = 'rounded' | 'circular';

export declare type TagSize = 'extra-small' | 'small' | 'medium';

export declare type TagSlots = {
    root: NonNullable<Slot<'button', 'span'>>;
    /**
     * Slot for a visual element, usually an avatar
     */
    media?: Slot<'span'>;
    /**
     * Slot for an icon
     */
    icon?: Slot<'span'>;
    /**
     * Main text for the Tag. Children of the root slot are automatically rendered here
     */
    primaryText: Slot<'span'>;
    /**
     * Secondary text that describes or complements the main text
     */
    secondaryText?: Slot<'span'>;
    /**
     * Slot for the dismiss icon
     */
    dismissIcon?: Slot<'span'>;
};

/**
 * State used in rendering Tag
 */
export declare type TagState = ComponentState<TagSlots> & Required<Pick<TagProps, 'appearance' | 'disabled' | 'dismissible' | 'selected' | 'shape' | 'size'>> & UseTagAvatarContextValuesOptions;

export declare type TagValue = string;

/**
 * Create the state required to render InteractionTag.
 *
 * The returned state can be modified with hooks such as useInteractionTagStyles_unstable,
 * before being passed to renderInteractionTag_unstable.
 *
 * @param props - props from this instance of InteractionTag
 * @param ref - reference to root HTMLDivElement of InteractionTag
 */
export declare const useInteractionTag_unstable: (props: InteractionTagProps, ref: React_2.Ref<HTMLDivElement>) => InteractionTagState;

export declare function useInteractionTagContextValues_unstable(state: InteractionTagState): InteractionTagContextValues;

/**
 * Create the state required to render InteractionTagPrimary.
 *
 * The returned state can be modified with hooks such as useInteractionTagPrimaryStyles_unstable,
 * before being passed to renderInteractionTagPrimary_unstable.
 *
 * @param props - props from this instance of InteractionTagPrimary
 * @param ref - reference to root HTMLButtonElement of InteractionTagPrimary
 */
export declare const useInteractionTagPrimary_unstable: (props: InteractionTagPrimaryProps, ref: React_2.Ref<HTMLButtonElement>) => InteractionTagPrimaryState;

export declare const useInteractionTagPrimaryStyles_unstable: (state: InteractionTagPrimaryState) => InteractionTagPrimaryState;

/**
 * Create the state required to render InteractionTagSecondary.
 *
 * The returned state can be modified with hooks such as useInteractionTagSecondaryStyles_unstable,
 * before being passed to renderInteractionTagSecondary_unstable.
 *
 * @param props - props from this instance of InteractionTagSecondary
 * @param ref - reference to root HTMLButtonElement of InteractionTagSecondary
 */
export declare const useInteractionTagSecondary_unstable: (props: InteractionTagSecondaryProps, ref: React_2.Ref<HTMLButtonElement>) => InteractionTagSecondaryState;

export declare const useInteractionTagSecondaryStyles_unstable: (state: InteractionTagSecondaryState) => InteractionTagSecondaryState;

/**
 * Apply styling to the InteractionTag slots based on the state
 */
export declare const useInteractionTagStyles_unstable: (state: InteractionTagState) => InteractionTagState;

/**
 * Create the state required to render Tag.
 *
 * The returned state can be modified with hooks such as useTagStyles_unstable,
 * before being passed to renderTag_unstable.
 *
 * @param props - props from this instance of Tag
 * @param ref - reference to root HTMLSpanElement or HTMLButtonElement of Tag
 */
export declare const useTag_unstable: (props: TagProps, ref: React_2.Ref<HTMLSpanElement | HTMLButtonElement>) => TagState;

export declare function useTagAvatarContextValues_unstable(state: UseTagAvatarContextValuesOptions): TagAvatarContextValues;

declare type UseTagAvatarContextValuesOptions = {
    avatarSize: AvatarSize;
    avatarShape: AvatarShape;
};

/**
 * Create the state required to render TagGroup.
 *
 * The returned state can be modified with hooks such as useTagGroupStyles_unstable,
 * before being passed to renderTagGroup_unstable.
 *
 * @param props - props from this instance of TagGroup
 * @param ref - reference to root HTMLDivElement of TagGroup
 */
export declare const useTagGroup_unstable: (props: TagGroupProps, ref: React_2.Ref<HTMLDivElement>) => TagGroupState;

export declare function useTagGroupContextValues_unstable(state: TagGroupState): TagGroupContextValues;

/**
 * Apply styling to the TagGroup slots based on the state
 */
export declare const useTagGroupStyles_unstable: (state: TagGroupState) => TagGroupState;

/**
 * Apply styling to the Tag slots based on the state
 */
export declare const useTagStyles_unstable: (state: TagState) => TagState;

export { }
