'use client';
import * as React from 'react';
import { TagPickerOption } from '../TagPickerOption';
function defaultRenderOption(option) {
    return /*#__PURE__*/ React.createElement(TagPickerOption, {
        value: option,
        key: option
    }, option);
}
export function useTagPickerFilter({ filter: filterOverride, noOptionsElement, renderOption = defaultRenderOption, query, options }) {
    const defaultFilter = React.useCallback((option)=>{
        const trimmedQuery = query.trim();
        if (trimmedQuery === '') {
            return true;
        }
        return option.toLowerCase().includes(trimmedQuery.toLowerCase());
    }, [
        query
    ]);
    const filter = filterOverride !== null && filterOverride !== void 0 ? filterOverride : defaultFilter;
    const filteredOptions = React.useMemo(()=>options.reduce((accumulator, option, index)=>{
            if (filter(option, index)) {
                accumulator.push(renderOption(option));
            }
            return accumulator;
        }, []), [
        options,
        renderOption,
        filter
    ]);
    return filteredOptions.length === 0 ? [
        noOptionsElement.key ? noOptionsElement : /*#__PURE__*/ React.cloneElement(noOptionsElement, {
            key: 'no-options'
        })
    ] : filteredOptions;
}
