'use client';
import * as React from 'react';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
export const useResizeObserverRef = (callback)=>{
    const { targetDocument } = useFluent();
    const [observer] = React.useState(()=>{
        var _targetDocument_defaultView;
        const ResizeObserverConstructor = targetDocument === null || targetDocument === void 0 ? void 0 : (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.ResizeObserver;
        if (ResizeObserverConstructor) {
            return new ResizeObserverConstructor(callback);
        }
    });
    const ref = React.useCallback((element)=>{
        if (element) {
            observer === null || observer === void 0 ? void 0 : observer.observe(element);
        } else {
            observer === null || observer === void 0 ? void 0 : observer.disconnect();
        }
    }, [
        observer
    ]);
    return ref;
};
