'use client';
import * as React from 'react';
import { useTagPickerContext_unstable } from '../contexts/TagPickerContext';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
export function useExpandLabel(options) {
    const { tagPickerId, state } = options;
    const { targetDocument } = useFluent();
    const triggerRef = useTagPickerContext_unstable((ctx)=>ctx.triggerRef);
    const expandIconRef = React.useRef(null);
    const hasExpandIcon = !!state.expandIcon;
    const { 'aria-label': expandIconAriaLabel, 'aria-labelledby': expandIconAriaLabelledby, id: expandIconId } = state.expandIcon || {};
    // If aria-label or aria-labelledby changes, recalculate aria-label and aria-labelledby for the expandIcon
    // The expandIcon's label is calculated based on the input's label
    // TODO: investigate ways to enforce client to provide a label rather than need to calculate it
    const getExpandLabel = React.useCallback((ariaLabel, ariaLabelledBy)=>{
        let expandAriaLabel = undefined;
        let expandAriaLabelledBy = undefined;
        let expandId = undefined;
        if (hasExpandIcon) {
            const hasExpandLabel = expandIconAriaLabel || expandIconAriaLabelledby;
            // If there is no explicit aria-label, calculate default accName attribute for expandIcon button,
            // using the following steps:
            // 1. If there is an aria-label, it is "Open [aria-label]"
            // 2. If there is an aria-labelledby, it is "Open [aria-labelledby target]" (using aria-labelledby + ids)
            // 3. If there is no aria-label/ledby attr, it falls back to "Open"
            // We can't fall back to a label/htmlFor name because of https://github.com/w3c/accname/issues/179
            const defaultOpenString = 'Open'; // this is english-only since it is the fallback
            if (!hasExpandLabel) {
                if (ariaLabelledBy) {
                    expandAriaLabel = defaultOpenString;
                    expandId = expandIconId !== null && expandIconId !== void 0 ? expandIconId : `${tagPickerId}-chevron`;
                    expandAriaLabelledBy = `${expandId} ${ariaLabelledBy}`;
                } else if (ariaLabel) {
                    expandAriaLabel = `${defaultOpenString} ${ariaLabel}`;
                } else {
                    expandAriaLabel = defaultOpenString;
                }
            }
        }
        return {
            expandAriaLabel,
            expandAriaLabelledBy,
            expandId
        };
    }, [
        expandIconAriaLabel,
        expandIconAriaLabelledby,
        expandIconId,
        hasExpandIcon,
        tagPickerId
    ]);
    const setExpandLabel = React.useCallback(()=>{
        var _triggerRef_current, _triggerRef_current1;
        const inputAriaLabel = (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.getAttribute('aria-label');
        const inputAriaLabelledBy = (_triggerRef_current1 = triggerRef.current) === null || _triggerRef_current1 === void 0 ? void 0 : _triggerRef_current1.getAttribute('aria-labelledby');
        const { expandAriaLabel, expandAriaLabelledBy, expandId } = getExpandLabel(inputAriaLabel, inputAriaLabelledBy);
        if (expandAriaLabelledBy) {
            var _expandIconRef_current;
            (_expandIconRef_current = expandIconRef.current) === null || _expandIconRef_current === void 0 ? void 0 : _expandIconRef_current.setAttribute('aria-labelledby', expandAriaLabelledBy);
        }
        if (expandAriaLabel) {
            var _expandIconRef_current1;
            (_expandIconRef_current1 = expandIconRef.current) === null || _expandIconRef_current1 === void 0 ? void 0 : _expandIconRef_current1.setAttribute('aria-label', expandAriaLabel);
        }
        if (expandId) {
            var _expandIconRef_current2;
            (_expandIconRef_current2 = expandIconRef.current) === null || _expandIconRef_current2 === void 0 ? void 0 : _expandIconRef_current2.setAttribute('id', expandId);
        }
    }, [
        getExpandLabel,
        triggerRef
    ]);
    React.useEffect(()=>{
        const hasExpandLabel = expandIconAriaLabel || expandIconAriaLabelledby;
        if (!(targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) || !triggerRef.current || !hasExpandIcon || hasExpandLabel) {
            return;
        }
        const win = targetDocument.defaultView;
        // On first render, calculate the default aria-label and aria-labelledby for the expandIcon
        setExpandLabel();
        const observer = new win.MutationObserver(setExpandLabel);
        observer.observe(triggerRef.current, {
            attributes: true,
            attributeFilter: [
                'aria-label',
                'aria-labelledby'
            ]
        });
        return ()=>observer.disconnect();
    }, [
        getExpandLabel,
        setExpandLabel,
        expandIconAriaLabel,
        expandIconAriaLabelledby,
        hasExpandIcon,
        tagPickerId,
        triggerRef,
        targetDocument
    ]);
    return expandIconRef;
}
