'use client';
import * as React from 'react';
import { createContext, useContextSelector } from '@fluentui/react-context-selector';
/**
 * @internal
 */ export const tagPickerContextDefaultValue = {
    triggerRef: React.createRef(),
    popoverRef: React.createRef(),
    targetRef: React.createRef(),
    tagPickerGroupRef: React.createRef(),
    secondaryActionRef: React.createRef(),
    open: false,
    clearSelection: ()=>null,
    getOptionById: ()=>undefined,
    selectedOptions: [],
    selectOption: ()=>null,
    setHasFocus: ()=>null,
    setOpen: ()=>null,
    setValue: ()=>null,
    value: undefined,
    popoverId: '',
    size: 'medium',
    appearance: 'outline',
    disabled: false
};
const TagPickerContext = createContext(undefined);
export const TagPickerContextProvider = TagPickerContext.Provider;
export const useTagPickerContext_unstable = (selector)=>useContextSelector(TagPickerContext, (ctx = tagPickerContextDefaultValue)=>selector(ctx));
