'use client';

import { __styles, mergeClasses, shorthands } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
export const tagPickerControlClassNames = {
  root: 'fui-TagPickerControl',
  expandIcon: 'fui-TagPickerControl__expandIcon',
  secondaryAction: 'fui-TagPickerControl__secondaryAction',
  aside: 'fui-TagPickerControl__aside'
};
export const tagPickerControlAsideWidthToken = '--fui-TagPickerControl-aside-width';
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    z189sj: ["f1d8q41i", "f8lqu5g"],
    uwmqm3: ["f1uw59to", "fw5db7e"],
    Bt984gj: "f122n59",
    i8kkvl: "f14mj54c",
    B7ck84d: "f1ewtqcl",
    mc9l5x: "f22iagw",
    Bf4jedk: "f1exfvgq",
    qhf8xq: "f10pi13n",
    Eh141a: "fni485r",
    Bbr2w1p: "f14a1fxs",
    Bduesf4: "f3e99gv",
    Bpq79vn: "fhljsf7",
    li1rpt: "f1gw3sf2",
    Bsft5z2: "f13zj6fq",
    E3zdtr: "f1mdlcz9",
    Eqx8gd: ["f1a7op3", "f1cjjd47"],
    By385i5: "f1gboi2j",
    B1piin3: ["f1cjjd47", "f1a7op3"],
    Dlnsje: "f145g4dw",
    d9w3h3: ["f1kp91vd", "f1ibwz09"],
    B3778ie: ["f1ibwz09", "f1kp91vd"],
    B1q35kw: 0,
    Bw17bha: 0,
    Bcgy8vk: 0,
    Bjuhk93: "f1mnjydx",
    Gjdm7m: "f13evtba",
    b1kco5: "f1yk9hq",
    Ba2ppi3: "fhwpy7i",
    F2fol1: "f14ee0xe",
    lck23g: "f1xhbsuh",
    df92cz: "fv8e3ye",
    I188md: "ftb5wc6",
    umuwi5: "fjw5xc1",
    Blcqepd: "f1xdyd5c",
    nplu4u: "fatpbeo",
    Bioka5o: "fb7uyps",
    H713fs: "f1cmft4k",
    B9ooomg: "f1x58t8o",
    Bercvud: "f1ibeo51"
  },
  listbox: {
    E5pizo: "f1hg901r",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    Bxyxcbc: "fmmk62d",
    B7ck84d: "f1ewtqcl"
  },
  listboxCollapsed: {
    mc9l5x: "fjseox"
  },
  medium: {
    sshi5w: "f1nxs5xn"
  },
  large: {
    sshi5w: "f1w5jphr"
  },
  "extra-large": {
    sshi5w: "f5pgtk9"
  },
  outline: {
    De3pzq: "fxugw4r",
    Bgfg5da: 0,
    B9xav0g: "f1c1zstj",
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "fhz96rm"
  },
  outlineInteractive: {
    Bgoe8wy: "fvcxoqz",
    Bwzppfd: ["f1ub3y4t", "f1m52nbi"],
    oetu4i: "f1l4zc64",
    gg5e9n: ["f1m52nbi", "f1ub3y4t"],
    B6oc9vd: "fvs00aa",
    ak43y8: ["f1assf6x", "f4ruux4"],
    wmxk5l: "f1z0osm6",
    B50zh58: ["f4ruux4", "f1assf6x"],
    Bvq3b66: "f1b473iu",
    Brahy3i: ["f381qr8", "ft4skwv"],
    zoxjo1: "f1qzcrsd",
    an54nd: ["ft4skwv", "f381qr8"]
  },
  underline: {
    De3pzq: "f1c21dwh",
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    Bgfg5da: "f9ez7ne",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "fokr779"
  },
  "filled-lighter": {
    De3pzq: "fxugw4r",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f88035w"
  },
  "filled-darker": {
    De3pzq: "f16xq7d1",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f88035w"
  },
  invalid: {
    tvckwq: "fs4k3qj",
    gk2u95: ["fcee079", "fmyw78r"],
    hhx65j: "f1fgmyf4",
    Bxowmz0: ["fmyw78r", "fcee079"]
  },
  invalidUnderline: {
    hhx65j: "f1fgmyf4"
  },
  disabled: {
    Bceei9c: "fdrzuqr",
    De3pzq: "f1c21dwh",
    g2u3we: "f1jj8ep1",
    h3c5rm: ["f15xbau", "fy0fskl"],
    B9xav0g: "f4ikngz",
    zhjwy3: ["fy0fskl", "f15xbau"],
    Bjwas2f: "fg455y9",
    Bn1d65q: ["f1rvyvqg", "f14g86mu"],
    Bxeuatn: "f1cwzwz",
    n51gp8: ["f14g86mu", "f1rvyvqg"]
  }
}, {
  d: [[".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], ".f1d8q41i{padding-right:calc(var(--spacingHorizontalM) + var(--fui-TagPickerControl-aside-width, 0px));}", ".f8lqu5g{padding-left:calc(var(--spacingHorizontalM) + var(--fui-TagPickerControl-aside-width, 0px));}", ".f1uw59to{padding-left:var(--spacingHorizontalM);}", ".fw5db7e{padding-right:var(--spacingHorizontalM);}", ".f122n59{align-items:center;}", ".f14mj54c{column-gap:var(--spacingHorizontalXXS);}", ".f1ewtqcl{box-sizing:border-box;}", ".f22iagw{display:flex;}", ".f1exfvgq{min-width:250px;}", ".f10pi13n{position:relative;}", ".fni485r{flex-wrap:wrap;}", ".f1gw3sf2::after{box-sizing:border-box;}", ".f13zj6fq::after{content:\"\";}", ".f1mdlcz9::after{position:absolute;}", ".f1a7op3::after{left:-1px;}", ".f1cjjd47::after{right:-1px;}", ".f1gboi2j::after{bottom:-1px;}", ".f145g4dw::after{height:max(2px, var(--borderRadiusMedium));}", ".f1kp91vd::after{border-bottom-left-radius:var(--borderRadiusMedium);}", ".f1ibwz09::after{border-bottom-right-radius:var(--borderRadiusMedium);}", [".f1mnjydx::after{border-bottom:var(--strokeWidthThick) solid var(--colorCompoundBrandStroke);}", {
    p: -1
  }], ".f13evtba::after{clip-path:inset(calc(100% - 2px) 0 0 0);}", ".f1yk9hq::after{transform:scaleX(0);}", ".fhwpy7i::after{transition-property:transform;}", ".f14ee0xe::after{transition-duration:var(--durationUltraFast);}", ".f1xhbsuh::after{transition-delay:var(--curveAccelerateMid);}", ".f1hg901r{box-shadow:var(--shadow16);}", [".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], ".fmmk62d{max-height:80vh;}", ".fjseox{display:none;}", ".f1nxs5xn{min-height:32px;}", ".f1w5jphr{min-height:40px;}", ".f5pgtk9{min-height:44px;}", ".fxugw4r{background-color:var(--colorNeutralBackground1);}", [".fhz96rm{border:var(--strokeWidthThin) solid var(--colorNeutralStroke1);}", {
    p: -2
  }], ".f1c1zstj{border-bottom-color:var(--colorNeutralStrokeAccessible);}", ".f1c21dwh{background-color:var(--colorTransparentBackground);}", [".f9ez7ne{border-bottom:var(--strokeWidthThin) solid var(--colorNeutralStrokeAccessible);}", {
    p: -1
  }], [".fokr779{border-radius:0;}", {
    p: -1
  }], [".f88035w{border:var(--strokeWidthThin) solid var(--colorTransparentStroke);}", {
    p: -2
  }], ".f16xq7d1{background-color:var(--colorNeutralBackground3);}", [".f88035w{border:var(--strokeWidthThin) solid var(--colorTransparentStroke);}", {
    p: -2
  }], ".fs4k3qj:not(:focus-within),.fs4k3qj:hover:not(:focus-within){border-top-color:var(--colorPaletteRedBorder2);}", ".fcee079:not(:focus-within),.fcee079:hover:not(:focus-within){border-right-color:var(--colorPaletteRedBorder2);}", ".fmyw78r:not(:focus-within),.fmyw78r:hover:not(:focus-within){border-left-color:var(--colorPaletteRedBorder2);}", ".f1fgmyf4:not(:focus-within),.f1fgmyf4:hover:not(:focus-within){border-bottom-color:var(--colorPaletteRedBorder2);}", ".fdrzuqr{cursor:not-allowed;}", ".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}", ".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}", ".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}", ".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}"],
  w: [".f14a1fxs:focus-within{outline-width:2px;}", ".f3e99gv:focus-within{outline-style:solid;}", ".fhljsf7:focus-within{outline-color:transparent;}", ".fjw5xc1:focus-within::after{transform:scaleX(1);}", ".f1xdyd5c:focus-within::after{transition-property:transform;}", ".fatpbeo:focus-within::after{transition-duration:var(--durationNormal);}", ".fb7uyps:focus-within::after{transition-delay:var(--curveDecelerateMid);}", ".f1ibeo51:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}", ".f1b473iu:focus-within{border-top-color:var(--colorNeutralStroke1Pressed);}", ".f381qr8:focus-within{border-right-color:var(--colorNeutralStroke1Pressed);}", ".ft4skwv:focus-within{border-left-color:var(--colorNeutralStroke1Pressed);}", ".f1qzcrsd:focus-within{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"],
  m: [["@media screen and (prefers-reduced-motion: reduce){.fv8e3ye::after{transition-duration:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media screen and (prefers-reduced-motion: reduce){.ftb5wc6::after{transition-delay:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media screen and (prefers-reduced-motion: reduce){.f1cmft4k:focus-within::after{transition-duration:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media screen and (prefers-reduced-motion: reduce){.f1x58t8o:focus-within::after{transition-delay:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media (forced-colors: active){.fg455y9{border-top-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f14g86mu{border-left-color:GrayText;}.f1rvyvqg{border-right-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1cwzwz{border-bottom-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }]],
  h: [".fvcxoqz:hover{border-top-color:var(--colorNeutralStroke1Hover);}", ".f1ub3y4t:hover{border-right-color:var(--colorNeutralStroke1Hover);}", ".f1m52nbi:hover{border-left-color:var(--colorNeutralStroke1Hover);}", ".f1l4zc64:hover{border-bottom-color:var(--colorNeutralStrokeAccessibleHover);}"],
  a: [".fvs00aa:active{border-top-color:var(--colorNeutralStroke1Pressed);}", ".f1assf6x:active{border-right-color:var(--colorNeutralStroke1Pressed);}", ".f4ruux4:active{border-left-color:var(--colorNeutralStroke1Pressed);}", ".f1z0osm6:active{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"]
});
const useAsideStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f22iagw",
    qhf8xq: "f1euv43f",
    Bhzewxz: "f15twtuk",
    j35jbq: ["f8b87gs", "fedtrts"],
    Bqenvij: "f1l02sjl",
    Bceei9c: "f113hnb5"
  },
  medium: {
    sshi5w: "f1nxs5xn"
  },
  large: {
    sshi5w: "f1w5jphr"
  },
  "extra-large": {
    sshi5w: "f5pgtk9"
  }
}, {
  d: [".f22iagw{display:flex;}", ".f1euv43f{position:absolute;}", ".f15twtuk{top:0;}", ".f8b87gs{right:var(--spacingHorizontalM);}", ".fedtrts{left:var(--spacingHorizontalM);}", ".f1l02sjl{height:100%;}", ".f113hnb5{cursor:text;}", ".f1nxs5xn{min-height:32px;}", ".f1w5jphr{min-height:40px;}", ".f5pgtk9{min-height:44px;}"]
});
export const iconSizes = {
  small: '16px',
  medium: '20px',
  large: '24px'
};
const useIconStyles = /*#__PURE__*/__styles({
  icon: {
    B7ck84d: "f1ewtqcl",
    sj55zd: "fxkbij4",
    Bceei9c: "f1k6fduh",
    mc9l5x: "f22iagw",
    Brf1p80: "f4d9j23",
    Bt984gj: "f122n59",
    qb2dma: "fjgzulp",
    Be2twd7: "f1pp30po",
    Bo70h7d: "fvc9v3g"
  },
  medium: {
    Be2twd7: "f4ybsrx",
    Frg6f3: ["f1h9en5y", "f1xk557c"],
    sshi5w: "f1nxs5xn"
  },
  large: {
    Be2twd7: "fe5j1ua",
    Frg6f3: ["f1h9en5y", "f1xk557c"],
    sshi5w: "f1w5jphr"
  },
  "extra-large": {
    Be2twd7: "f1rt2boy",
    Frg6f3: ["f1t5qyk5", "f1ikr372"],
    sshi5w: "f5pgtk9"
  },
  disabled: {
    sj55zd: "f1s2aq7o",
    Bceei9c: "fdrzuqr"
  }
}, {
  d: [".f1ewtqcl{box-sizing:border-box;}", ".fxkbij4{color:var(--colorNeutralStrokeAccessible);}", ".f1k6fduh{cursor:pointer;}", ".f22iagw{display:flex;}", ".f4d9j23{justify-content:center;}", ".f122n59{align-items:center;}", ".fjgzulp{align-self:flex-start;}", ".f1pp30po{font-size:var(--fontSizeBase500);}", ".fvc9v3g svg{display:block;}", ".f4ybsrx{font-size:16px;}", ".f1h9en5y{margin-left:var(--spacingHorizontalXXS);}", ".f1xk557c{margin-right:var(--spacingHorizontalXXS);}", ".f1nxs5xn{min-height:32px;}", ".fe5j1ua{font-size:20px;}", ".f1w5jphr{min-height:40px;}", ".f1rt2boy{font-size:24px;}", ".f1t5qyk5{margin-left:var(--spacingHorizontalSNudge);}", ".f1ikr372{margin-right:var(--spacingHorizontalSNudge);}", ".f5pgtk9{min-height:44px;}", ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}", ".fdrzuqr{cursor:not-allowed;}"]
});
const useSecondaryActionStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f22iagw"
  }
}, {
  d: [".f22iagw{display:flex;}"]
});
/**
 * Apply styling to the PickerControl slots based on the state
 */
export const useTagPickerControlStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const iconStyles = useIconStyles();
  const asideStyles = useAsideStyles();
  const secondaryActionStyles = useSecondaryActionStyles();
  state.root.className = mergeClasses(tagPickerControlClassNames.root, styles.root, styles[state.size], styles[state.appearance], !state.disabled && state.appearance === 'outline' && styles.outlineInteractive, state.invalid && state.appearance !== 'underline' && styles.invalid, state.invalid && state.appearance === 'underline' && styles.invalidUnderline, state.disabled && styles.disabled, state.root.className);
  if (state.aside) {
    state.aside.className = mergeClasses(tagPickerControlClassNames.aside, asideStyles.root, asideStyles[state.size], state.aside.className);
  }
  if (state.expandIcon) {
    state.expandIcon.className = mergeClasses(tagPickerControlClassNames.expandIcon, iconStyles.icon, iconStyles[state.size], state.disabled && iconStyles.disabled, state.expandIcon.className);
  }
  if (state.secondaryAction) {
    state.secondaryAction.className = mergeClasses(tagPickerControlClassNames.secondaryAction, secondaryActionStyles.root, state.secondaryAction.className);
  }
  return state;
};