'use client';
import * as React from 'react';
import { elementContains, getIntrinsicElementProps, slot, useEventCallback, useId, useMergedRefs } from '@fluentui/react-utilities';
import { useFluent_unstable } from '@fluentui/react-shared-contexts';
import { useTagPickerContext_unstable } from '../../contexts/TagPickerContext';
import { ChevronDownRegular } from '@fluentui/react-icons';
import { useResizeObserverRef } from '../../utils/useResizeObserverRef';
import { tagPickerControlAsideWidthToken } from './useTagPickerControlStyles.styles';
import { useFieldContext_unstable } from '@fluentui/react-field';
import { useExpandLabel } from '../../utils/useExpandLabel';
/**
 * Create the state required to render PickerControl.
 *
 * The returned state can be modified with hooks such as usePickerControlStyles_unstable,
 * before being passed to renderPickerControl_unstable.
 *
 * @param props - props from this instance of PickerControl
 * @param ref - reference to root HTMLDivElement of PickerControl
 */ export const useTagPickerControl_unstable = (props, ref)=>{
    var _useFieldContext_unstable;
    const targetRef = useTagPickerContext_unstable((ctx)=>ctx.targetRef);
    const triggerRef = useTagPickerContext_unstable((ctx)=>ctx.triggerRef);
    const tagPickerGroupRef = useTagPickerContext_unstable((ctx)=>ctx.tagPickerGroupRef);
    const open = useTagPickerContext_unstable((ctx)=>ctx.open);
    const popoverId = useTagPickerContext_unstable((ctx)=>ctx.popoverId);
    const setOpen = useTagPickerContext_unstable((ctx)=>ctx.setOpen);
    const secondaryInnerActionRef = useTagPickerContext_unstable((ctx)=>ctx.secondaryActionRef);
    const size = useTagPickerContext_unstable((ctx)=>ctx.size);
    const appearance = useTagPickerContext_unstable((ctx)=>ctx.appearance);
    const disabled = useTagPickerContext_unstable((ctx)=>ctx.disabled);
    const invalid = ((_useFieldContext_unstable = useFieldContext_unstable()) === null || _useFieldContext_unstable === void 0 ? void 0 : _useFieldContext_unstable.validationState) === 'error';
    const noPopover = useTagPickerContext_unstable((ctx)=>{
        var _ctx_noPopover;
        return (_ctx_noPopover = ctx.noPopover) !== null && _ctx_noPopover !== void 0 ? _ctx_noPopover : false;
    });
    const { targetDocument } = useFluent_unstable();
    const tagPickerId = useId('tagPicker-');
    const rafIdRef = React.useRef(null);
    const innerRef = React.useRef(null);
    const expandIconRef = React.useRef(null);
    const asideRef = React.useRef(null);
    const secondaryAction = slot.optional(props.secondaryAction, {
        elementType: 'span'
    });
    const secondaryActionRef = useMergedRefs(secondaryInnerActionRef, secondaryAction === null || secondaryAction === void 0 ? void 0 : secondaryAction.ref);
    if (secondaryAction) {
        secondaryAction.ref = secondaryActionRef;
    }
    const expandIcon = slot.optional(props.expandIcon, {
        renderByDefault: !noPopover,
        defaultProps: {
            'aria-expanded': open,
            'aria-disabled': disabled ? 'true' : undefined,
            children: /*#__PURE__*/ React.createElement(ChevronDownRegular, null),
            role: 'button'
        },
        elementType: 'span'
    });
    const expandIconMergeRef = useMergedRefs(expandIcon === null || expandIcon === void 0 ? void 0 : expandIcon.ref, expandIconRef);
    if (expandIcon) {
        expandIcon.ref = expandIconMergeRef;
    }
    const observerRef = useResizeObserverRef(([entry])=>{
        const targetWindow = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
        if (targetWindow) {
            rafIdRef.current = targetWindow.requestAnimationFrame(()=>{
                var _innerRef_current;
                (_innerRef_current = innerRef.current) === null || _innerRef_current === void 0 ? void 0 : _innerRef_current.style.setProperty(tagPickerControlAsideWidthToken, `${entry.contentRect.width}px`);
            });
        }
    });
    const aside = slot.optional(undefined, {
        elementType: 'span',
        renderByDefault: Boolean(secondaryAction || expandIcon),
        defaultProps: {
            ref: observerRef
        }
    });
    const mergedAsideRefs = useMergedRefs(asideRef, aside === null || aside === void 0 ? void 0 : aside.ref);
    if (aside) {
        aside.ref = mergedAsideRefs;
    }
    const handleMouseDown = useEventCallback((event)=>{
        if (event.isDefaultPrevented()) {
            return;
        }
        if (elementContains(expandIconRef.current, event.target) || event.target === innerRef.current || event.target === tagPickerGroupRef.current || event.target === asideRef.current) {
            var _triggerRef_current;
            event.preventDefault();
            setOpen(event, !open);
            (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
        }
    });
    const state = {
        components: {
            root: 'div',
            expandIcon: 'span',
            secondaryAction: 'span',
            aside: 'span'
        },
        root: slot.always(getIntrinsicElementProps('div', {
            ref: useMergedRefs(ref, targetRef, innerRef),
            'aria-owns': open && !noPopover ? popoverId : undefined,
            ...props,
            onMouseDown: handleMouseDown
        }), {
            elementType: 'div'
        }),
        aside,
        expandIcon,
        secondaryAction,
        size,
        appearance,
        disabled,
        invalid
    };
    const expandIconLabelRef = useExpandLabel({
        tagPickerId,
        state: state
    });
    const expandIconLabelMergeRef = useMergedRefs(expandIcon === null || expandIcon === void 0 ? void 0 : expandIcon.ref, expandIconLabelRef);
    if (state.expandIcon) {
        state.expandIcon.ref = expandIconLabelMergeRef;
    }
    React.useEffect(()=>{
        if (rafIdRef.current && (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView)) {
            targetDocument.defaultView.cancelAnimationFrame(rafIdRef.current);
        }
    }, [
        targetDocument
    ]);
    return state;
};
