'use client';
import * as React from 'react';
import { useTagPickerButton_unstable } from './useTagPickerButton';
import { renderTagPickerButton_unstable } from './renderTagPickerButton';
import { useTagPickerButtonStyles_unstable } from './useTagPickerButtonStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * TagPickerButton component -
 * A TagPickerButton is an alternative to TagPickerInput that does not include an input field.
 */ export const TagPickerButton = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useTagPickerButton_unstable(props, ref);
    useTagPickerButtonStyles_unstable(state);
    useCustomStyleHook_unstable('useTagPickerButtonStyles_unstable')(state);
    return renderTagPickerButton_unstable(state);
});
TagPickerButton.displayName = 'TagPickerButton';
