'use client';
import * as React from 'react';
export function useTagPickerContextValues(state) {
    const { onOptionClick, registerOption, selectedOptions, selectOption, value, triggerRef, secondaryActionRef, tagPickerGroupRef, targetRef, size, setValue, setOpen, setHasFocus, popoverRef, appearance, clearSelection, getOptionById, getOptionsMatchingValue, open, popoverId, disabled, noPopover } = state;
    return {
        activeDescendant: React.useMemo(()=>({
                controller: state.activeDescendantController
            }), [
            state.activeDescendantController
        ]),
        listbox: {
            onOptionClick,
            registerOption,
            getOptionById,
            getOptionsMatchingValue,
            selectedOptions,
            selectOption,
            focusVisible: false,
            setActiveOption: noop
        },
        picker: {
            value,
            triggerRef,
            targetRef,
            secondaryActionRef,
            tagPickerGroupRef,
            size,
            setValue,
            setOpen,
            setHasFocus,
            selectOption,
            popoverRef,
            selectedOptions,
            appearance,
            clearSelection,
            getOptionById,
            open,
            popoverId,
            disabled,
            noPopover
        }
    };
}
const noop = ()=>{
/** noop */ };
