import * as React from 'react';
import { ActiveDescendantContextProvider } from '@fluentui/react-aria';
import { ListboxProvider } from '@fluentui/react-combobox';
import { Portal } from '@fluentui/react-portal';
import { assertSlots } from '@fluentui/react-utilities';
import { TagPickerContextProvider } from '../../contexts/TagPickerContext';
/**
 * Render the final JSX of Picker
 */ export const renderTagPicker_unstable = (state, contexts)=>{
    assertSlots(state);
    return /*#__PURE__*/ React.createElement(TagPickerContextProvider, {
        value: contexts.picker
    }, /*#__PURE__*/ React.createElement(ActiveDescendantContextProvider, {
        value: contexts.activeDescendant
    }, /*#__PURE__*/ React.createElement(ListboxProvider, {
        value: contexts.listbox
    }, state.trigger, state.popover && (state.inline ? state.popover : /*#__PURE__*/ React.createElement(Portal, {
        mountNode: state.mountNode
    }, state.popover)))));
};
