'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTagPickerFilter", {
    enumerable: true,
    get: function() {
        return useTagPickerFilter;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _TagPickerOption = require("../TagPickerOption");
function defaultRenderOption(option) {
    return /*#__PURE__*/ _react.createElement(_TagPickerOption.TagPickerOption, {
        value: option,
        key: option
    }, option);
}
function useTagPickerFilter({ filter: filterOverride, noOptionsElement, renderOption = defaultRenderOption, query, options }) {
    const defaultFilter = _react.useCallback((option)=>{
        const trimmedQuery = query.trim();
        if (trimmedQuery === '') {
            return true;
        }
        return option.toLowerCase().includes(trimmedQuery.toLowerCase());
    }, [
        query
    ]);
    const filter = filterOverride !== null && filterOverride !== void 0 ? filterOverride : defaultFilter;
    const filteredOptions = _react.useMemo(()=>options.reduce((accumulator, option, index)=>{
            if (filter(option, index)) {
                accumulator.push(renderOption(option));
            }
            return accumulator;
        }, []), [
        options,
        renderOption,
        filter
    ]);
    return filteredOptions.length === 0 ? [
        noOptionsElement.key ? noOptionsElement : /*#__PURE__*/ _react.cloneElement(noOptionsElement, {
            key: 'no-options'
        })
    ] : filteredOptions;
}
