'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagPickerOptionClassNames: function() {
        return tagPickerOptionClassNames;
    },
    useTagPickerOptionStyles_unstable: function() {
        return useTagPickerOptionStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactcombobox = require("@fluentui/react-combobox");
const _reacttheme = require("@fluentui/react-theme");
const tagPickerOptionClassNames = {
    root: 'fui-TagPickerOption',
    media: 'fui-TagPickerOption__media',
    secondaryContent: 'fui-TagPickerOption__secondaryContent'
};
const useRootBaseStyle = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center'
});
const useRootStyles = (0, _react.makeStyles)({
    secondaryContent: {
        display: 'grid',
        gridTemplateColumns: 'auto 1fr'
    }
});
const useSecondaryContentBaseStyle = (0, _react.makeResetStyles)({
    gridColumnStart: 2,
    gridRowStart: 2,
    ..._reacttheme.typographyStyles.caption1
});
const useMediaBaseStyle = (0, _react.makeResetStyles)({
    gridRowStart: 'span 2'
});
const useTagPickerOptionStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyle = useRootBaseStyle();
    const rootStyles = useRootStyles();
    const secondaryContentBaseStyle = useSecondaryContentBaseStyle();
    const mediaBaseStyle = useMediaBaseStyle();
    state.root.className = (0, _react.mergeClasses)(tagPickerOptionClassNames.root, rootBaseStyle, state.secondaryContent && rootStyles.secondaryContent, state.root.className);
    (0, _reactcombobox.useOptionStyles_unstable)({
        ...state,
        active: false,
        disabled: false,
        focusVisible: false,
        checkIcon: undefined,
        selected: false
    });
    if (state.media) {
        state.media.className = (0, _react.mergeClasses)(tagPickerOptionClassNames.media, mediaBaseStyle, state.media.className);
    }
    if (state.secondaryContent) {
        state.secondaryContent.className = (0, _react.mergeClasses)(tagPickerOptionClassNames.secondaryContent, secondaryContentBaseStyle, state.secondaryContent.className);
    }
    return state;
};
