'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagPickerListClassNames: function() {
        return tagPickerListClassNames;
    },
    useTagPickerListStyles_unstable: function() {
        return useTagPickerListStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tagPickerListClassNames = {
    root: 'fui-TagPickerList'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        boxShadow: `${_reacttheme.tokens.shadow16}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        maxHeight: '80vh',
        boxSizing: 'border-box'
    },
    collapsed: {
        display: 'none'
    }
});
const useTagPickerListStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(tagPickerListClassNames.root, styles.root, !state.open && styles.collapsed, state.root.className);
    return state;
};
