'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagPickerInputClassNames: function() {
        return tagPickerInputClassNames;
    },
    useTagPickerInputStyles_unstable: function() {
        return useTagPickerInputStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _tokens = require("../../utils/tokens");
const tagPickerInputClassNames = {
    root: 'fui-TagPickerInput'
};
const useBaseStyle = (0, _react.makeResetStyles)({
    backgroundColor: _reacttheme.tokens.colorTransparentBackground,
    color: _reacttheme.tokens.colorNeutralForeground1,
    fontFamily: _reacttheme.tokens.fontFamilyBase,
    boxSizing: 'border-box',
    '&:focus': {
        outlineStyle: 'none'
    },
    '&::placeholder': {
        color: _reacttheme.tokens.colorNeutralForeground4,
        opacity: 1
    },
    '&::after': {
        visibility: 'hidden',
        whiteSpace: 'pre-wrap'
    },
    border: 'none',
    minWidth: '24px',
    maxWidth: '100%',
    // by default width is 0,
    // it will be calculated based on the requirement of stretching the component to 100% width
    // see setTagPickerInputStretchStyle method for more details
    width: _tokens.tagPickerInputTokens.width,
    flexGrow: 1
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    // size variants
    medium: {
        ..._reacttheme.typographyStyles.body1,
        padding: `${_reacttheme.tokens.spacingVerticalSNudge} 0 ${_reacttheme.tokens.spacingVerticalSNudge} 0`
    },
    large: {
        ..._reacttheme.typographyStyles.body1,
        padding: `${_reacttheme.tokens.spacingVerticalMNudge} 0 ${_reacttheme.tokens.spacingVerticalMNudge} 0`
    },
    'extra-large': {
        ..._reacttheme.typographyStyles.body1,
        padding: `${_reacttheme.tokens.spacingVerticalM} 0 ${_reacttheme.tokens.spacingVerticalM} 0`
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        cursor: 'not-allowed',
        '::placeholder': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    }
});
const useTagPickerInputStyles_unstable = (state)=>{
    'use no memo';
    const baseStyle = useBaseStyle();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(tagPickerInputClassNames.root, baseStyle, styles[state.size], state.disabled && styles.disabled, state.root.className);
    return state;
};
