'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagPickerGroupClassNames: function() {
        return tagPickerGroupClassNames;
    },
    useTagPickerGroupStyles_unstable: function() {
        return useTagPickerGroupStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttags = require("@fluentui/react-tags");
const _reacttheme = require("@fluentui/react-theme");
const _tagPicker2Tag = require("../../utils/tagPicker2Tag");
const tagPickerGroupClassNames = {
    root: 'fui-TagPickerGroup'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        flexWrap: 'wrap',
        boxSizing: 'border-box',
        cursor: 'text'
    },
    // size variants
    medium: {
        padding: `${_reacttheme.tokens.spacingVerticalSNudge} 0 ${_reacttheme.tokens.spacingVerticalSNudge} 0`,
        gap: _reacttheme.tokens.spacingHorizontalXS
    },
    large: {
        padding: `${_reacttheme.tokens.spacingVerticalS} 0 ${_reacttheme.tokens.spacingVerticalS} 0`,
        gap: _reacttheme.tokens.spacingHorizontalSNudge
    },
    'extra-large': {
        padding: `${_reacttheme.tokens.spacingVerticalS} 0 ${_reacttheme.tokens.spacingVerticalS} 0`,
        gap: _reacttheme.tokens.spacingHorizontalSNudge
    }
});
const useTagPickerGroupStyles_unstable = (state)=>{
    'use no memo';
    (0, _reacttags.useTagGroupStyles_unstable)(state);
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(tagPickerGroupClassNames.root, styles[(0, _tagPicker2Tag.tagSizeToTagPickerSize)(state.size)], styles.root, state.root.className);
    return state;
};
