'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTagPickerGroup_unstable", {
    enumerable: true,
    get: function() {
        return useTagPickerGroup_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttags = require("@fluentui/react-tags");
const _TagPickerContext = require("../../contexts/TagPickerContext");
const _reactutilities = require("@fluentui/react-utilities");
const _tagPicker2Tag = require("../../utils/tagPicker2Tag");
const _reacttabster = require("@fluentui/react-tabster");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const useTagPickerGroup_unstable = (props, ref)=>{
    const hasSelectedOptions = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.selectedOptions.length > 0);
    const hasOneSelectedOption = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.selectedOptions.length === 1);
    const triggerRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.triggerRef);
    const tagPickerGroupRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.tagPickerGroupRef);
    const selectOption = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.selectOption);
    const size = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>(0, _tagPicker2Tag.tagPickerSizeToTagSize)(ctx.size));
    const appearance = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.appearance);
    const disabled = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.disabled);
    const arrowNavigationProps = (0, _reacttabster.useArrowNavigationGroup)({
        circular: false,
        axis: 'both',
        memorizeCurrent: true
    });
    const state = (0, _reacttags.useTagGroup_unstable)({
        role: 'listbox',
        disabled,
        ...props,
        ...arrowNavigationProps,
        size,
        appearance: (0, _tagPicker2Tag.tagPickerAppearanceToTagAppearance)(appearance),
        dismissible: true,
        onKeyDown: (0, _reactutilities.useEventCallback)((event)=>{
            var _props_onKeyDown;
            (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, event);
            if ((0, _reactutilities.isHTMLElement)(event.target) && event.key === _keyboardkeys.ArrowRight) {
                var _triggerRef_current;
                (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
            }
        }),
        onDismiss: (0, _reactutilities.useEventCallback)((event, data)=>{
            selectOption(event, {
                value: data.value,
                // These values no longer exist because the option has unregistered itself
                // for the purposes of selection - these values aren't actually used
                id: 'ERROR_DO_NOT_USE',
                text: 'ERROR_DO_NOT_USE'
            });
            if (hasOneSelectedOption && !event.isDefaultPrevented()) {
                var _triggerRef_current;
                (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
            }
        })
    }, (0, _reactutilities.useMergedRefs)(ref, tagPickerGroupRef));
    return {
        ...state,
        hasSelectedOptions
    };
};
