'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    iconSizes: function() {
        return iconSizes;
    },
    tagPickerControlAsideWidthToken: function() {
        return tagPickerControlAsideWidthToken;
    },
    tagPickerControlClassNames: function() {
        return tagPickerControlClassNames;
    },
    useTagPickerControlStyles_unstable: function() {
        return useTagPickerControlStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tagPickerControlClassNames = {
    root: 'fui-TagPickerControl',
    expandIcon: 'fui-TagPickerControl__expandIcon',
    secondaryAction: 'fui-TagPickerControl__secondaryAction',
    aside: 'fui-TagPickerControl__aside'
};
const tagPickerControlAsideWidthToken = '--fui-TagPickerControl-aside-width';
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        paddingRight: `calc(${_reacttheme.tokens.spacingHorizontalM} + var(${tagPickerControlAsideWidthToken}, 0px))`,
        paddingLeft: _reacttheme.tokens.spacingHorizontalM,
        alignItems: 'center',
        columnGap: _reacttheme.tokens.spacingHorizontalXXS,
        boxSizing: 'border-box',
        display: 'flex',
        minWidth: '250px',
        position: 'relative',
        flexWrap: 'wrap',
        // windows high contrast mode focus indicator
        ':focus-within': {
            outlineWidth: '2px',
            outlineStyle: 'solid',
            outlineColor: 'transparent'
        },
        // bottom focus border, shared with Input, Select, and SpinButton
        '::after': {
            boxSizing: 'border-box',
            content: '""',
            position: 'absolute',
            left: '-1px',
            bottom: '-1px',
            right: '-1px',
            height: `max(2px, ${_reacttheme.tokens.borderRadiusMedium})`,
            borderBottomLeftRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottomRightRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottom: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorCompoundBrandStroke}`,
            clipPath: 'inset(calc(100% - 2px) 0 0 0)',
            transform: 'scaleX(0)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationUltraFast,
            transitionDelay: _reacttheme.tokens.curveAccelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within::after': {
            transform: 'scaleX(1)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationNormal,
            transitionDelay: _reacttheme.tokens.curveDecelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within:active::after': {
            borderBottomColor: _reacttheme.tokens.colorCompoundBrandStrokePressed
        }
    },
    listbox: {
        boxShadow: `${_reacttheme.tokens.shadow16}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        maxHeight: '80vh',
        boxSizing: 'border-box'
    },
    listboxCollapsed: {
        display: 'none'
    },
    // size variants
    medium: {
        minHeight: '32px'
    },
    large: {
        minHeight: '40px'
    },
    'extra-large': {
        minHeight: '44px'
    },
    // appearance variants
    outline: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
    },
    outlineInteractive: {
        '&:hover': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        '&:active': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        },
        '&:focus-within': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        }
    },
    underline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
        borderRadius: '0'
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    },
    invalidUnderline: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            borderBottomColor: _reacttheme.tokens.colorPaletteRedBorder2
        }
    },
    disabled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        }
    }
});
const useAsideStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        position: 'absolute',
        top: '0',
        right: _reacttheme.tokens.spacingHorizontalM,
        height: '100%',
        cursor: 'text'
    },
    // size variants
    medium: {
        minHeight: '32px'
    },
    large: {
        minHeight: '40px'
    },
    'extra-large': {
        minHeight: '44px'
    }
});
const iconSizes = {
    small: '16px',
    medium: '20px',
    large: '24px'
};
const useIconStyles = (0, _react.makeStyles)({
    icon: {
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralStrokeAccessible,
        cursor: 'pointer',
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        alignSelf: 'flex-start',
        fontSize: _reacttheme.tokens.fontSizeBase500,
        // the SVG must have display: block for accurate positioning
        // otherwise an extra inline space is inserted after the svg element
        '& svg': {
            display: 'block'
        }
    },
    // icon size variants
    medium: {
        fontSize: iconSizes.small,
        marginLeft: _reacttheme.tokens.spacingHorizontalXXS,
        minHeight: '32px'
    },
    large: {
        fontSize: iconSizes.medium,
        marginLeft: _reacttheme.tokens.spacingHorizontalXXS,
        minHeight: '40px'
    },
    'extra-large': {
        fontSize: iconSizes.large,
        marginLeft: _reacttheme.tokens.spacingHorizontalSNudge,
        minHeight: '44px'
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed'
    }
});
const useSecondaryActionStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex'
    }
});
const useTagPickerControlStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const asideStyles = useAsideStyles();
    const secondaryActionStyles = useSecondaryActionStyles();
    state.root.className = (0, _react.mergeClasses)(tagPickerControlClassNames.root, styles.root, styles[state.size], styles[state.appearance], !state.disabled && state.appearance === 'outline' && styles.outlineInteractive, state.invalid && state.appearance !== 'underline' && styles.invalid, state.invalid && state.appearance === 'underline' && styles.invalidUnderline, state.disabled && styles.disabled, state.root.className);
    if (state.aside) {
        state.aside.className = (0, _react.mergeClasses)(tagPickerControlClassNames.aside, asideStyles.root, asideStyles[state.size], state.aside.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(tagPickerControlClassNames.expandIcon, iconStyles.icon, iconStyles[state.size], state.disabled && iconStyles.disabled, state.expandIcon.className);
    }
    if (state.secondaryAction) {
        state.secondaryAction.className = (0, _react.mergeClasses)(tagPickerControlClassNames.secondaryAction, secondaryActionStyles.root, state.secondaryAction.className);
    }
    return state;
};
